#!/bin/sh
# Script for installing MusiXTeX in UNIX systems with TeTeX
# Kindly provided by: <dirk@calvyn.puk.ac.za>

# MusiXTeX installation script for Unix systems.
# This script is right for the TETeX distribution.  You will
# need to do similar things on any other distribution.

# You have just un-tarred the distribution and this file
# is in the present working directory.  You are root, of course.

# LOCALBIN is the directory for locally defined executables
LOCALBIN=/usr/local/bin

# TEXMF is the TeX/MetaFont root directory.  A Unix TeX installation
# has a utility giving information about itself, so use it.
TEXMF=`kpsetool -v '$TEXMF'`

# Mark all files world readable
chmod -R +r *
# Mark all directories world executable
chmod +x * systems/*

# Build musixflx
cd systems/c-source
cc -o musixflx musixflx.c
cd $OLDPWD

# Link files to where they are visible
ln -s $PWD/systems/c-source/musixflx $LOCALBIN
ln -s $PWD/mf $TEXMF/fonts/source/musixtex
ln -s $PWD/tfm $TEXMF/fonts/tfm/musixtex
ln -s $PWD/tex $TEXMF/tex/generic/musixtex

# Ask your distribution to update its file list
texhash
-----------------------------------------------------------------------


File uninstall.sh:
-----------------------------------------------------------------------
#!/bin/sh
# MusiXTeX uninstallation script for Unix systems.
# This script is right for the TETeX distribution.  You will
# need to do similar things on any other distribution.

# LOCALBIN is the directory for locally defined executables
LOCALBIN=/usr/local/bin

# TEXMF is the TeX/MetaFont root directory.
TEXMF=`kpsetool -v '$TEXMF'`

# Link files to where they are visible
rm $LOCALBIN/musixflx
rm $TEXMF/fonts/source/musixtex
rm $TEXMF/fonts/tfm/musixtex
rm $TEXMF/tex/generic/musixtex

# Ask your distribution to update its file list
texhash

