 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/


class UnitIndex;

#ifndef __UNITINDEX_H__
#define __UNITINDEX_H__

#include "EST.h"
#include "UnitDatabase.h"
#include "SubtypedObject.h"


/** Abstraction for indecies. Different selection methods can have
  * different indexing styles. This interface just defines what the
  * general database handler needs to know about them.
  * <p>
  * An index maps a set of properties onto a set of unit names.
  * @see UnitCatalogue
  * @author Richard Caley <rjc@cstr,ed,ac,uk>
  * @version $Id: UnitIndex.h,v 1.1 1998/08/12 09:35:52 awb Exp $
  */

class UnitIndex : public SubtypedObject<UnitIndex> {

private:

  /// The database this index is to be used with.
  UnitDatabase *p_database;

protected:
  /// Record which database to use this with.
  void set_database(UnitDatabase *db) {p_database=db;};

public:

  /// Default constructor.
  UnitIndex(void);
  /// Destructor.
  virtual ~UnitIndex(void); 

  /// Get the database to use.
  UnitDatabase *database(void) const {return p_database;};


  /**@name Subtyping */
  //@{
  /// Read in from the file.
  virtual EST_read_status fill_from(FILE *stream, int binary=1);
  /// Write out to file.
  virtual EST_write_status write_to(FILE *stream, int binary=1);
 /// Record the filename.
  void set_filename(EST_String) { };
  //@}

  /**@name Properties */
  //@{
  /// Set a single property.
  virtual int set_property(EST_String property, ValueType value);
  //@}


  /// Say which database to use.
  virtual void associate_database(UnitDatabase *db);
  /// Build the index.
  virtual void index(void);

#if 0
  /// Lookup functions. Not defined in UnitIndex.
  EST_Vector<UnitName> lookup(YOUR_ARGUMENTS_HERE) const;
#endif

  /**@name Garbage collection 
   * Mark and unmark as part of database.
   */
  //@{
  /// Mark as accessable.
  virtual void gc_mark(void) 
	{if (p_database) p_database->gc_mark(); else p_gc_mark++;} ;
  /// Unmark.
  virtual void gc_clear_mark(void) 
	{if (p_database) p_database->gc_clear_mark(); else p_gc_mark=0;};
  /// Check if marked as accessable.
  virtual int  gc_marked(void) 
	{return (p_database?(p_database->gc_marked()):p_gc_mark);};
  //@}


#if defined(INCLUDE_LISP)  

  /**@name Scheme interface
    * These are the functions which are imported into Scheme. 
    */
  //@{
  /// Print out object
  static void lisp_print(LISP, FILE *);
  /// Print object to string.
  static void lisp_print_string(LISP, char *);
  /// Initialisation function.
  static void lisp_declare(void);
  //@}
#endif

  friend class SubtypedObject<UnitIndex>;
};


#endif
