#include "cs.h"			/*			     WINDIN.C	*/
#include "window.h"
#include "windin.h"		/* real-time input control units	*/
				/* 26aug90 dpwe				*/

extern void (*mkxyFn)();	/* pointer to xyinput window creator */
extern void (*rdxyFn)();	/* pointer to xyinput window creator */

void xyinset(XYIN *p)
{
    float	f;

    if ((p->timcount = (int)(ekr * *p->iprd)) <= 0)
        initerror("illegal iprd");
    if (*p->iymin > *p->iymax) {           	/* swap if wrong order */
      f = *p->iymin; *p->iymin = *p->iymax; *p->iymax = f;
    }
    if (*p->iymin == *p->iymax)	{ /* force some room (why?) */
      *p->iymax = *p->iymin + 1.0f;    	/* say.. */
      *p->iymin -= 1.0f;
    }
    if (*p->iyinit < *p->iymin) 		*p->iyinit = *p->iymin;
    else if (*p->iyinit > *p->iymax) 	*p->iyinit = *p->iymax;

    if (*p->ixmin > *p->ixmax)   	/* swap if wrong order */
	{  f = *p->ixmin; *p->ixmin = *p->ixmax; *p->ixmax = f; }
    if (*p->ixmin == *p->ixmax)  	/* force some room (why?) */
	{
	*p->ixmax = *p->ixmin + 1.0f;    	/* say.. */
	*p->ixmin -= 1.0f;
	}
    if (*p->ixinit < *p->ixmin) 		*p->ixinit = *p->ixmin;
    else if (*p->ixinit > *p->ixmax) 	*p->ixinit = *p->ixmax;

    (*mkxyFn)(&p->w,(*p->ixinit - *p->ixmin)/(*p->ixmax - *p->ixmin), 
	           (*p->iyinit - *p->iymin)/(*p->iymax - *p->iymin) );

    p->countdown = 1;           /* init counter to run xyin on first call */
    }

#ifndef __MWERKS__
void xyin(XYIN *p)
{
    if (!(--p->countdown)) {                  /* at each countdown   */
        p->countdown = p->timcount;           /*   reset counter &   */
	(*rdxyFn)(&p->w);                      /*   read cursor postn */
	*(p->kxrslt) = *p->ixmin + p->w.x * (*p->ixmax - *p->ixmin);
	*(p->kyrslt) = *p->iymin + (1.0f - p->w.y) * (*p->iymax - *p->iymin);
	/*  printf("x: %5.2f   y:%5.2f \n", *p->kxrslt, *p->kyrslt); */
    }
}
#else
void xyin(XYIN *p)
{
	int inside = 0;
	CursHandle cursor;
	
	if (!(--p->countdown)) {                  /* at each countdown   */
	  p->countdown = p->timcount;           /*   reset counter &   */
	  (*rdxyFn)(&p->w);                      /*   read cursor postn */
/* 	*(p->kxrslt) = *p->ixmin + p->w.x * (*p->ixmax - *p->ixmin); */
/* 	*(p->kyrslt) = *p->iymin + (1.0 - p->w.y) * (*p->iymax - *p->iymin); */
	  if (p->w.x >= *p->ixmin && p->w.x <= *p->ixmax)	inside++;
	  if (p->w.y >= *p->iymin && p->w.y <= *p->iymax) inside++;
	  if (inside == 2) {
	    *(p->kxrslt) = p->w.x;		/* Mike 11/2/96 for Mac */
	    *(p->kyrslt) = p->w.y;		/* /Mike 11/2/96 for Mac */
	    cursor = GetCursor(128);
	    SetCursor(*cursor);
	  } else {
	    SetCursor(&(qd.arrow));
	  }
	/*  printf("x: %5.2f   y:%5.2f \n", *p->kxrslt, *p->kyrslt); */
    }
}
#endif
