/* This file is Copyright 1993 by Clifford A. Adams */
/* svirt.c
 *
 * Virtual (newsgroup) scan mode
 */

#include "EXTERN.h"
#include "common.h"
#ifdef SCAN

#include "scan.h"
#include "scmd.h"
#include "sdisp.h"
#include "smisc.h"	/* needed? */
#include "sorder.h"	/* needed? */
#include "spage.h"

#include "scanart.h"
#include "svdata.h"
#include "svfile.h"
#include "svmisc.h"
#include "svonline.h"
#include "term.h"
#include "util.h"
#include "INTERN.h"
#include "svirt.h"

/* returns TRUE for successful init, false otherwise */
bool
sv_init(fname,title)
char *fname;
char *title;
{
    /* check to see if screen is big enough */
    if (!sv_check_screen()) {
	printf("Sorry--the screen is too small for group scan mode.\n") FLUSH;
	return(FALSE);
    }
    sv_loop = TRUE;
    sv_init_context();

    sv_in_setup = TRUE;

    sv_init_settings();
    sv_use_file(fname,title);
    sv_in_setup = FALSE;
/* CONSIDER: this initialization/check is late in the initialization. */
    if (s_initscreen()) {		/* If not able to init screen...*/
	sv_cleanup();
	sv_loop = FALSE;
	return(FALSE);			/* ...most likely dumb terminal */
    }
    sv_initialized = TRUE;
    sv_save_context();
    return(TRUE);
}

void
sv_add_context(fname,title)
char *fname;
char *title;
{
    sv_in_setup = TRUE;

    sv_init_settings();

    sv_use_file(fname,title);
    sv_in_setup = FALSE;
    sv_save_context();
}

/* consider next-virtual-newsgroup command? */
int
sv_continue()
{
    char sv_oldmode;
    int i;

    sv_loop = TRUE;
    /* return to the virtual scan-context */
    sv_restore_context();

    /* If a major change was made to the .newsrc (like reordering or
     * deleting newsgroups), adjust to the changes.
     */
/* VIRT: reinit group pointers sometimes? */

    /* redraw it *all* */
    s_ref_all = TRUE;
    if ((s_top_ent<1) || (s_top_ent>=sv_num_ents))
	s_top_ent = s_first();
    i = s_fillpage();
    if (((i==-1) || (i == 0)) && sv_e_unread) {
	/* if all of the entries are read, enter unread+read mode */
/* This is a poor solution(?)--think of something better later? */
	sv_e_unread = FALSE;
	i = s_fillpage();
    }
    if ((i==-1) || (i == 0)) {
	printf("virtual scan mode: no eligible articles.\n") FLUSH;
	printf("Type the 'e' key to edit, or any other to exit.\n") FLUSH;
	/* for now just leave if no page could be filled. */
	eat_typeahead();
	getcmd(buf);
	eat_typeahead();
	if ((*buf == 'e') || (*buf == 'E')) {
	    s_ref_all = TRUE;
	    sv_edit_file();
	}
	sv_loop = FALSE;
	sv_cleanup();
	return(SV_RETURN);
    }
    sv_oldmode = mode;			/* save mode */
    mode = 'v';				/* for RN macros */
    i = s_cmdloop();
    mode = sv_oldmode;			/* restore mode */
    if (i>0) {		/* an entry is selected */
/*	sv_read_article(sv_groups[sv_ents[i].group].name); /* */
	printf("Going to newsgroup %s\n",
		sv_groups[sv_ents[i].group].name) FLUSH;
	/* the command will set the fake */
	if (sv_num_contexts)
	    sv_save_context();
	return(SV_FAKE);
    }
    /* something else (quit, return, etc...) */
    if (i==SV_QUIT) {
	sv_loop = FALSE;
	sv_cleanup();
	return(SV_RETURN);
    }
    if (sv_num_contexts)
	sv_save_context();
    return(i);
}

int
sv_main(fname,title)
char *fname;
char *title;
{
    if (sa_initialized)
	sa_cleanup();		/* we aren't very compatible */
    if (sv_initialized) {	/* new context */
	sv_add_context(fname,title);
	return(sv_continue());
    }
    if (!sv_init(fname,title))	/* failed to initialize */
	return(SV_RETURN);	/* just leave group scan mode for now */
    return(sv_continue());
}
#endif /* SCAN */
