/* $Id: mmalloc.h,v 1.1.1.1 1998/07/29 15:14:27 proff Exp $
 * $Copyright$
 */

#ifndef MMALLOC_H
#define MMALLOC_H 1

#include "nconf.h"

#include <sys/types.h>
#include "mmap.h"

#include "mm_ansidecl.h"
 
/* Allocate SIZE bytes of memory.  */

extern PTR mmalloc PARAMS ((PTR, size_t));
extern PTR mmalloc_check PARAMS ((PTR, size_t, char *));

/* Re-allocate the previously allocated block in PTR, making the new block
   SIZE bytes long.  */

extern PTR mrealloc PARAMS ((PTR, PTR, size_t));
extern PTR mrealloc_check PARAMS ((PTR, PTR, size_t, char *));

/* Allocate NMEMB elements of SIZE bytes each, all initialized to 0.  */

extern PTR mcalloc PARAMS ((PTR, size_t, size_t));
extern PTR mcalloc_check PARAMS ((PTR, size_t, size_t, char *));

/* Free a block allocated by `mmalloc', `mrealloc' or `mcalloc'.  */

extern void mfree PARAMS ((PTR, PTR));
extern void mfree_check PARAMS ((PTR, PTR, char *));

/* Allocate SIZE bytes allocated to ALIGNMENT bytes.  */

extern PTR mmemalign PARAMS ((PTR, size_t, size_t));

/* Allocate SIZE bytes on a page boundary.  */

extern PTR mvalloc PARAMS ((PTR, size_t));

/* Activate a debugging hook.  */

extern void mmcheck PARAMS ((PTR, void (*) (void *, char *, int)));

/* Pick up the current statistics. (see FIXME elsewhere) */

extern struct mstats mmstats PARAMS ((PTR));

extern PTR mmalloc_attach PARAMS ((int, PTR, int));

extern PTR mmalloc_detach PARAMS ((PTR));

extern int mmalloc_setkey PARAMS ((PTR, int, PTR));

extern PTR mmalloc_getkey PARAMS ((PTR, int));

extern int mmalloc_errno PARAMS ((PTR));

extern int mmtrace PARAMS ((void));

/* Bits to look at in the malloc descriptor flags word */

#define MMALLOC_DEVZERO		(1 << 0)	/* Have mapped to /dev/zero */
#define MMALLOC_INITIALIZED	(1 << 1)	/* Initialized mmalloc */
#define MMALLOC_MMCHECK_USED	(1 << 2)	/* mmcheck() called already */
#define MMALLOC_ANON		(1 << 3)	/* Have mapped anonymous region */
#define MMALLOC_FILE		(1 << 4)	/* Have mapped anonymous region */

#endif  /* MMALLOC_H */
