.TH lqr 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
leqr - H-infinity LQ gain (full state)
.SH CALLING SEQUENCE
.nf
[K,X,err]=leqr(P12,Vx)
.fi
.SH PARAMETERS
.TP 10
P12
: \fVsyslin\fR list
.TP
Vx
: symmetric nonnegative matrix (should be small enough)
.TP
K,X
: two real matrices
.TP
err
: a real number (l1 norm of LHS of Riccati equation)
.SH DESCRIPTION
\fVleqr\fR  computes the linear suboptimal H-infinity LQ full-state gain
for the plant \fVP12=[A,B2,C1,D12]\fR in continuous or discrete time.
.LP
\fVP12\fR is a \fVsyslin\fR list (e.g. \fVP12=syslin('c',A,B2,C1,D12)\fR).
.nf
      [C1' ]               [Q  S]
      [    ]  * [C1 D12] = [    ]
      [D12']               [S' R]
.fi
\fVVx\fR is related to the variance matrix of the noise \fVw\fR perturbing \fVx\fR;
(usually \fVVx=gama^-2*B1*B1'\fR).
.LP
The gain \fVK\fR is such that \fVA + B2*K\fR is stable.
.LP
\fVX\fR is the stabilizing solution of the Riccati equation.
.LP
For a continuous plant:
.nf
(A-B2*inv(R)*S')'*X+X*(A-B2*inv(R)*S')-X*(B2*inv(R)*B2'-Vx)*X+Q-S*inv(R)*S'=0
.fi
.nf
K=-inv(R)*(B2'*X+S)
.fi
.LP
For a discrete time plant:
.nf
X-(Abar'*inv((inv(X)+B2*inv(R)*B2'-Vx))*Abar+Qbar=0
.fi
.nf
K=-inv(R)*(B2'*inv(inv(X)+B2*inv(R)*B2'-Vx)*Abar+S')
.fi
with \fVAbar=A-B2*inv(R)*S'\fR and \fVQbar=Q-S*inv(R)*S'\fR
.LP
The 3-blocks matrix pencils associated with these Riccati equations are:
.nf
               discrete                        continuous
   |I  -Vx  0|   | A    0    B2|       |I   0   0|   | A    Vx    B2|
  z|0   A'  0| - |-Q    I    -S|      s|0   I   0| - |-Q   -A'   -S |
   |0   B2' 0|   | S'   0     R|       |0   0   0|   | S'   -B2'   R|
.fi
.LP \fVleqe\fR is the dual of \fVleqr\fR.
.SH SEE ALSO
lqr
.SH AUTHOR
F.D.

