#include "../cthugha.h"
#include "../sound.h"
#include "../options.h"
#include "../cd_player.h"
#include "../network.h"
#include "../keys.h"
#include "../server.h"
#include "../interface.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/soundcard.h>
#include <math.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <ncurses.h>


int_var_t int_var;
text_t * main_text = NULL;
text_t * msg_text = NULL;

char * cthugha_mode_text() {
    return "serv";
}
/*
 * Get a "line" of sound from the soundcard 
 */
int serv_sound_read() {

    if( nr_clients == 0) {		/* if no client connected, */
	free_sound();			/* we don't need the sound device */
	return 0;
    }

    alloc_sound();			/* make sure we have the sound dev */

    sound_read();

    return 0;
}

int cth_init(int * argc, char * argv[]) {

    server = 1;

    return 0;
}

int cth_main() {
    int clr = 1;

    free_sound();

    int_var.key = ' ';

    do {
	(clr) ? clear() : erase(); 
	clr = 0;

	serv_sound_read();
	broadcast_sound();

	server_accept();

#if USE_CDROM == 1
	cd_check();
#endif
	cd_pre_key();
	while( (int_var.key = getkey()) != CK_NONE) {
	    switch(int_var.key) {
	    case CK_ESC: case 'q': case 'Q':
		return 0;
	    case ' ':
		clr = 1;
	    default:
		cd_do_key();
	    }
	}
	cd_post_key();
	
	print_clients();

	refresh();


	if(srv_wait_time)			/* wait for a short while */
	    usleep(srv_wait_time*1000);		/* to give clients a chance */
						/* to display everything */
    } while(1);

    return 0;
}
