/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
/*
** lslOpList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ lslOpList
lslOpList_new ()
{
  lslOpList s = (lslOpList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->nspace = lslOpListBASESIZE;
  s->elements = (lslOp *)
    dmalloc (sizeof (*s->elements) * lslOpListBASESIZE);

  return (s);
}

static void
lslOpList_grow (lslOpList s)
{
  int i;
  lslOp *newelements; 

  s->nspace += lslOpListBASESIZE;
  
  newelements = (lslOp *) dmalloc (sizeof (*newelements)
					 * (s->nelements + s->nspace));
  
  if (newelements == (lslOp *) 0)
    {
      llfatalerror (cstring_makeLiteral ("lslOpList_grow: out of memory!"));
    }

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements);
  s->elements = newelements;
}

void 
lslOpList_add (lslOpList s, lslOp el)
{
  llassert (lslOpListBASESIZE != 0);

  if (s->nspace <= 0)
    {
      lslOpList_grow (s);
    }

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;
}

/*@only@*/ cstring
lslOpList_unparse (lslOpList s)
{
  int i;
  cstring st = cstring_undefined;

  for (i = 0; i < s->nelements; i++)
    {
      st = message ("%q%q\n", st, lslOp_unparse (s->elements[i]));
    }

  return st;
}

void
lslOpList_free (lslOpList s)
{
  sfree (s->elements);	
  sfree (s);
}
