/* --------------------------------------------------------------------*/
/*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \   /  '                               */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome. Send them to                                          */
/*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
/*-------------------------------------------------------------------- */
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.9b/Clib/inline-alloc.c      */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Sep 21 15:33:10 1994                          */
/*    Last change :  Fri Jun 20 14:58:04 1997 (serrano)                */
/*    -------------------------------------------------------------    */
/*    On fait des fonctions d'allocations specialisees pour les cons   */
/*    et les flottants.                                                */
/*=====================================================================*/
#ifndef GC_PRIVATE_H
#  include <gc_private.h>
#endif
#undef abs

#include <bigloo1.9c.h>

#if( THE_GC == BOEHM_GC )
#   define NUMBER_OF_CONS_WORDS (long)BYTES_TO_WORDS( PAIR_SIZE )
#   define NUMBER_OF_FLOAT_WORDS BYTES_TO_WORDS( REAL_SIZE )

/*---------------------------------------------------------------------*/
/*    alloc_make_pair ...                                              */
/*---------------------------------------------------------------------*/
static obj_t 
alloc_make_pair( obj_t car, obj_t cdr )
{
   obj_t pair;

   pair = (obj_t)GC_generic_malloc_words_small( NUMBER_OF_CONS_WORDS, NORMAL );


#if( !defined( TAG_PAIR ) )
   pair->pair_t.header = MAKE_HEADER( PAIR_TYPE, PAIR_SIZE );
#endif
   pair->pair_t.car    = car;
   pair->pair_t.cdr    = cdr;
   
   return BPAIR( pair );
}   

/*---------------------------------------------------------------------*/
/*    make_pair ...                                                    */
/*---------------------------------------------------------------------*/
obj_t 
make_pair( obj_t car, obj_t cdr )
{
   obj_t pair;
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;
   

   opp = &(GC_objfreelist[ NUMBER_OF_CONS_WORDS ]);

   FASTLOCK();

   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
   {
      FASTUNLOCK();
      return alloc_make_pair( car, cdr );
   }
   else
   {
      *opp = obj_link( op );
      GC_words_allocd += NUMBER_OF_CONS_WORDS;
      FASTUNLOCK();

      pair = (obj_t)op;

#if( !defined( TAG_PAIR ) )
      pair->pair_t.header = MAKE_HEADER( PAIR_TYPE, PAIR_SIZE );
#endif
      pair->pair_t.car    = car;
      pair->pair_t.cdr    = cdr;
   
      return BPAIR( pair );
   }
}

/*---------------------------------------------------------------------*/
/*    alloc_make_real ...                                              */
/*---------------------------------------------------------------------*/
static obj_t
alloc_make_real( double d )
{
   obj_t real;

   real = (obj_t)GC_generic_malloc_words_small(NUMBER_OF_FLOAT_WORDS, PTRFREE);
   
#if( !defined( TAG_REAL ) || defined( BUMPY_GC ) )
   real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
   real->real_t.real   = d;

   return BREAL( real );
}

/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
make_real( double d )
{
   obj_t real;
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;

   opp =  &(GC_aobjfreelist[ NUMBER_OF_FLOAT_WORDS ]);

   FASTLOCK();

   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
   {
      FASTUNLOCK();
      return alloc_make_real( d );
   }
   else
   {
      *opp = obj_link(op);
      GC_words_allocd += NUMBER_OF_FLOAT_WORDS;
      FASTUNLOCK();

      real = (obj_t)op;

#if( !defined( TAG_REAL ) )
      real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
      real->real_t.real   = d;

      return BREAL( real );
   }
}

#else

/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
make_real( double real )
{
   obj_t a_real, aux;

   a_real = GC_MALLOC_ATOMIC( REAL_SIZE );
	
#if( !defined( TAG_REAL ) )
   a_real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
   a_real->real_t.real = real;
	
   return BREAL( a_real );
}
#endif

