;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Module/statexp.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  4 10:58:45 1996                          */
;*    Last change :  Fri Aug 22 07:46:40 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The static clauses compilation.                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_statexp
   (include "Ast/unit.sch")
   (import  module_module
	    module_prototype
	    module_class
	    module_checksum
	    tools_error
	    tools_args
	    type_type
	    ast_var
	    ast_ident
	    ast_find-gdefs
	    ast_glo-decl)
   (export  (make-static-compiler)
	    (make-export-compiler)))

;*---------------------------------------------------------------------*/
;*    make-static-compiler ...                                         */
;*---------------------------------------------------------------------*/
(define (make-static-compiler)
   (instantiate::ccomp (id 'static)
		       (producer statexp-producer)))

;*---------------------------------------------------------------------*/
;*    make-export-compiler ...                                         */
;*---------------------------------------------------------------------*/
(define (make-export-compiler)
   (instantiate::ccomp (id 'export)
		       (producer statexp-producer)
		       (consumer export-consumer)
		       (finalizer statexp-finalizer)
		       (checksummer export-checksummer)))

;*---------------------------------------------------------------------*/
;*    statexp-producer ...                                             */
;*---------------------------------------------------------------------*/
(define (statexp-producer clause)
   (let ((mode (car clause)))
      (match-case clause
	 ((?- . ?protos)
	  (for-each (lambda (proto) (statexp-parser proto mode)) protos)
	  '())
	 (else
	  (user-error "Parse error"
		      (string-append "Illegal `"
				     (string-downcase (symbol->string mode))
				     "' clause")
		      clause
		      '())))))

;*---------------------------------------------------------------------*/
;*    export-consumer ...                                              */
;*---------------------------------------------------------------------*/
(define (export-consumer module clause)
   (match-case clause
      ((?- . ?protos)
       protos)
      (else
       (user-error "Parse error" "Illegal `export' clause" clause '()))))
   
;*---------------------------------------------------------------------*/
;*    statexp-parser ...                                               */
;*---------------------------------------------------------------------*/
(define (statexp-parser prototype import)
   (let ((proto (parse-prototype prototype)))
      (if (not (pair? proto))
	  (user-error "Parse error" "Illegal prototype" prototype '())
	  (case (car proto)
	     ((sfun sifun sgfun)
	      (to-be-define! (declare-global-sfun! (cadr proto)
						   (caddr proto)
						   *module*
						   import
						   (car proto)
						   prototype)))
	     ((svar)
	      (to-be-define! (declare-global-svar! (cadr proto)
						   *module*
						   import
						   prototype)))
	     ((class)
	      (to-be-declare! (delay (declare-class! (cdr proto)
						     *module*
						     import
						     #f
						     prototype))))
	     ((final-class)
	      (to-be-declare! (delay (declare-class! (cdr proto)
						     *module*
						     import
						     #t
						     prototype))))
	     ((wide-class)
	      (to-be-declare! (delay (declare-wide-class! (cdr proto)
							  *module*
							  import
							  prototype))))
	     (else
	      (user-error "Parse error" "Illegal prototype" prototype '()))))))

;*---------------------------------------------------------------------*/
;*    *local-classes* ...                                              */
;*---------------------------------------------------------------------*/
(define *local-classes* '())

;*---------------------------------------------------------------------*/
;*    to-be-declare! ...                                               */
;*---------------------------------------------------------------------*/
(define (to-be-declare! exp)
   (set! *local-classes* (cons exp *local-classes*)))

;*---------------------------------------------------------------------*/
;*    statexp-finalizer ...                                            */
;*    -------------------------------------------------------------    */
;*    we declare local classes. They must be declared after imported   */
;*    classes (then after the finalization of imported modules)        */
;*    otherwise the class declaration process would fail when checking */
;*    the super class types (saying something like they are not        */
;*    classes). That why we have froozen their declaration until now.  */
;*---------------------------------------------------------------------*/
(define (statexp-finalizer)
   ;; we declare local classes
   (for-each force (reverse! *local-classes*))
   (set! *local-classes* '())
   ;; and we can finalize them
   (let ((classes (class-finalizer)))
      (if (pair? classes)
	  classes
	  'void)))

;*---------------------------------------------------------------------*/
;*    export-checksummer ...                                           */
;*    -------------------------------------------------------------    */
;*    The checksum associated to an export clause.                     */
;*---------------------------------------------------------------------*/
(define (export-checksummer eclause checksum)
   (define (proto-checksummer clause checksum)
      (let ((proto          (parse-prototype clause))
	    (symbol->number (lambda (s)
			       (string->0..2^x-1 (symbol->string s) 16))))
	 (if (not (pair? proto))
	     (user-error "Parse error" "Illegal prototype" eclause '())
	     (case (car proto)
		((sfun sifun sgfun)
		 (let loop ((checksum (bit-xor
				       (symbol->number (car proto))
				       (bit-xor (symbol->number (cadr proto))
						(bit-xor (arity (caddr proto))
							 checksum))))
			    (args     (caddr proto)))
		    (cond
		       ((null? args)
			checksum)
		       ((not (pair? args))
			(bit-xor (symbol->number 'obj) checksum))
		       ((cnst? (car args))
			(loop (bit-xor (cnst->integer (car args)) checksum)
			      (cdr args)))
		       (else
			(let* ((type (type-of-id (car args)))
			       (tid  (type-id type)))
			   (loop (bit-xor (symbol->number tid) checksum)
				 (cdr args)))))))
		((svar)
		 (bit-xor checksum (symbol->number (cadr proto))))
		((class)
		 (bit-xor checksum (get-class-hash (cadr proto) clause)))
		((final-class)
		 (bit-xor checksum
			  (bit-xor 12543
				   (get-class-hash (cadr proto) clause))))
		((wide-class)
		 (bit-xor checksum
			  (bit-xor 456747
				   (get-class-hash (cadr proto) clause))))
		(else
		 (user-error "Parse error" "Illegal prototype" clause '()))))))
   (let loop ((clauses  (cdr eclause))
	      (checksum checksum))
      (if (null? clauses)
	  checksum
	  (loop (cdr clauses)
		(proto-checksummer (car clauses) checksum)))))

  
   
