/* xkeycaps, Copyright (c) 1991, 1992, 1993, 1994, 1996
 * Jamie Zawinski <jwz@jwz.org>
 *
 * Default mapping for Tektronix XN10/XN11 with Swedish keyboard
 * By Kristian Ejvind (Kristian.Ejvind@sth.frontec.se)
 */

/* Taken from TEKkeysym.h, in XP software distribution */
#ifndef  TekXK_Remove
# define TekXK_Remove	0x1000FF00
#endif
#ifndef  TekXK_Hold
# define TekXK_Hold	0x1000FF10
#endif
#ifndef  TekXK_Copy
# define TekXK_Copy	0x1000FF11
#endif
#ifndef  TekXK_Setup
# define TekXK_Setup	0x1000FF12
#endif
#ifndef  TekXK_Tek
# define TekXK_Tek	0x1000FFFF
#endif

static const struct default_keycode_map tekxn10_sf_map [] = {
  {   9, 0,		{ XK_Escape,	XK_Escape }},
  {  10, 0,		{ XK_asciitilde,	XK_degree }},
  {  11, 0,		{ XK_1,	XK_exclam }},
  {  12, 0,		{ XK_2,	XK_quotedbl }},
  {  13, 0,		{ XK_3,	XK_section }},
  {  14, 0,		{ XK_4,	XK_currency }},
  {  15, 0,		{ XK_5,	XK_percent }},
  {  16, 0,		{ XK_6,	XK_ampersand }},
  {  17, 0,		{ XK_7,	XK_slash }},
  {  18, 0,		{ XK_8,	XK_parenleft }},
  {  19, 0,		{ XK_9,	XK_parenright }},
  {  20, 0,		{ XK_0,	XK_equal }},
  {  21, 0,		{ XK_plus,	XK_question }},
  {  22, 0,		{ XK_asciicircum,	XK_grave }},
  {  23, 0,		{ XK_BackSpace,	XK_BackSpace }},
  {  24, 0,		{ XK_Delete,	XK_Delete }},
  {  25, 0,		{ XK_Linefeed,	XK_Linefeed }},
  {  26, 0,		{ XK_Tab,	XK_Tab }},
  {  27, 0,		{ XK_q,	XK_Q }},
  {  28, 0,		{ XK_w,	XK_W }},
  {  29, 0,		{ XK_e,	XK_E }},
  {  30, 0,		{ XK_r,	XK_R }},
  {  31, 0,		{ XK_t,	XK_T }},
  {  32, 0,		{ XK_y,	XK_Y }},
  {  33, 0,		{ XK_u,	XK_U }},
  {  34, 0,		{ XK_i,	XK_I }},
  {  35, 0,		{ XK_o,	XK_O }},
  {  36, 0,		{ XK_p,	XK_P }},
  {  37, 0,		{ XK_aring,	XK_Aring }},
  {  38, 0,		{ XK_udiaeresis,	XK_Udiaeresis }},
  {  39, 0,		{ XK_Return,	XK_Return }},
  {  40, ControlMask,	{ XK_Control_L,	XK_Control_L }},
  {  41, LockMask,	{ XK_Caps_Lock,	XK_Caps_Lock }},
  {  42, 0,		{ XK_a,	XK_A }},
  {  43, 0,		{ XK_s,	XK_S }},
  {  44, 0,		{ XK_d,	XK_D }},
  {  45, 0,		{ XK_f,	XK_F }},
  {  46, 0,		{ XK_g,	XK_G }},
  {  47, 0,		{ XK_h,	XK_H }},
  {  48, 0,		{ XK_j,	XK_J }},
  {  49, 0,		{ XK_k,	XK_K }},
  {  50, 0,		{ XK_l,	XK_L }},
  {  51, 0,		{ XK_odiaeresis,	XK_Odiaeresis }},
  {  52, 0,		{ XK_adiaeresis,	XK_Adiaeresis }},
  {  53, 0,		{ XK_apostrophe,	XK_asterisk }},
  {  54, ShiftMask,	{ XK_Shift_L,	XK_Shift_L }},
  {  55, 0,		{ XK_less,	XK_greater }},
  {  56, 0,		{ XK_z,	XK_Z }},
  {  57, 0,		{ XK_x,	XK_X }},
  {  58, 0,		{ XK_c,	XK_C }},
  {  59, 0,		{ XK_v,	XK_V }},
  {  60, 0,		{ XK_b,	XK_B }},
  {  61, 0,		{ XK_n,	XK_N }},
  {  62, 0,		{ XK_m,	XK_M }},
  {  63, 0,		{ XK_comma,	XK_semicolon }},
  {  64, 0,		{ XK_period,	XK_colon }},
  {  65, 0,		{ XK_minus,	XK_underscore }},
  {  66, ShiftMask,	{ XK_Shift_R,	XK_Shift_R }},
  {  67, Mod1Mask,	{ XK_Alt_L,	XK_Alt_L }},
  {  68, 0,		{ XK_space,	XK_space }},
  {  69, 0,		{ TekXK_Tek,	TekXK_Tek }},
  {  70, 0,		{ XK_KP_F1,	XK_KP_F1 }},
  {  71, 0,		{ XK_KP_F2,	XK_KP_F2 }},
  {  72, 0,		{ XK_KP_F3,	XK_KP_F3 }},
  {  73, 0,		{ XK_KP_F4,	XK_KP_F4 }},
  {  74, 0,		{ XK_KP_7,	XK_KP_7 }},
  {  75, 0,		{ XK_KP_8,	XK_KP_8 }},
  {  76, 0,		{ XK_KP_9,	XK_KP_9 }},
  {  77, 0,		{ XK_KP_Subtract,	XK_KP_Subtract }},
  {  78, 0,		{ XK_KP_4,	XK_KP_4 }},
  {  79, 0,		{ XK_KP_5,	XK_KP_5 }},
  {  80, 0,		{ XK_KP_6,	XK_KP_6 }},
  {  81, 0,		{ XK_KP_Separator,	XK_KP_Separator }},
  {  82, 0,		{ XK_KP_1,	XK_KP_1 }},
  {  83, 0,		{ XK_KP_2,	XK_KP_2 }},
  {  84, 0,		{ XK_KP_3,	XK_KP_3 }},
  {  85, 0,		{ XK_KP_0,	XK_KP_0 }},
  {  86, 0,		{ XK_KP_Decimal,	XK_KP_Decimal }},
  {  87, 0,		{ XK_KP_Enter,	XK_KP_Enter }},
  {  88, 0,		{ XK_Find,	XK_Find }},
  {  89, 0,		{ XK_Insert,	XK_Insert }},
  {  90, 0,	        { TekXK_Remove, TekXK_Remove }},
  {  91, 0,		{ XK_Select,	XK_Select }},
  {  92, 0,		{ XK_Prior,	XK_Prior }},
  {  93, 0,		{ XK_Next,	XK_Next }},
  {  94, 0,		{ TekXK_Hold,	TekXK_Hold }},
  {  95, 0,		{ TekXK_Copy,	TekXK_Copy }},
  {  96, 0,	        { TekXK_Setup,    TekXK_Setup }},
  {  97, 0,		{ XK_Menu,	XK_Menu }},
  {  98, 0,		{ XK_Break,	XK_Break }},
  {  99, 0,		{ XK_F6,		XK_F6 }},
  { 100, 0,		{ XK_F7,		XK_F7 }},
  { 101, 0,		{ XK_F8,		XK_F8 }},
  { 102, 0,		{ XK_F9,		XK_F9 }},
  { 103, 0,		{ XK_F10,		XK_F10 }},
  { 104, 0,		{ XK_F11,		XK_F11 }},
  { 105, 0,		{ XK_F12,		XK_F12 }},
  { 106, 0,		{ XK_F13,		XK_F13 }},
  { 107, 0,		{ XK_F14,		XK_F14 }},
  { 108, 0,		{ XK_Help,	XK_Help }},
  { 109, 0,		{ XK_Execute,	XK_Execute }},
  { 110, 0,		{ XK_F17,		XK_F17 }},
  { 111, 0,		{ XK_F18,		XK_F18 }},
  { 112, 0,		{ XK_F19,		XK_F19 }},
  { 113, 0,		{ XK_F20,		XK_F20 }},
  { 114, 0,		{ XK_Right,	XK_Right }},
  { 115, 0,		{ XK_Up,		XK_Up }},
  { 116, 0,		{ XK_Left,	XK_Left }},
  { 117, 0,		{ XK_Down,	XK_Down }},
  /*
   * It's impossible to generate keycode 118 on this keyboard,
   * but it still has got a default mapping! 
   */
  { 118, Mod1Mask,	{ 0 }},
  };
