/* ------------------------------------------------------------------------- */
/* bit-lpc.c i2c-hw access for parallel port adapters over control port	     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995-97 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */
static char rcsid[] = "$Id: bit-lpc.c,v 1.2 1998/01/20 10:01:29 i2c Exp i2c $";
/*
 * $Log: bit-lpc.c,v $
 * Revision 1.2  1998/01/20 10:01:29  i2c
 * *** empty log message ***
 *
 * Revision 1.1  1997/05/29 17:33:56  i2c
 * Initial revision
 *
 *
 */

#include <linux/kernel.h>
#include <linux/ioport.h>
#include <asm/io.h>

#include "i2c.h"
#include "i2c-priv.h"

/* ----- global defines -----------------------------------------------	*/
#define DEB(x)		/* should be reasonable open, close &c. 	*/
#define DEB2(x)		/* low level debugging - very slow 		*/
#define DEBE(x)	x	/* error messages 				*/

/* ----- local functions --------------------------------------------------- */
#if (BITADAPS) == 1
#define Local inline
#define bit_lpc_getscl getscl
#define bit_lpc_setscl setscl
#define bit_lpc_getsda getsda
#define bit_lpc_setsda setsda
#define bit_lpc_bit_init bit_init
#define bit_lpc_bit_exit bit_exit
#else
#define Local static
#endif

static char ctrlval=0;			/* remember control port value	*/

#define SCL	0x08			/* Printer Select -- inverted	*/
#define SDA	0x02			/* Auto Linefeed -- inverted	*/
#define SCLIN	0x08			/* Printer Select -- inverted	*/
#define SDAIN	0x10			/* Auto Linefeed -- inverted	*/

Local void bit_lpc_setscl(int minor, int state)
{
	if (state) {
		ctrlval &= !SCL;
	} else {
		ctrlval |= SCL;
	}
	outb_p(ctrlval, CTRL);
}


Local void bit_lpc_setsda(int minor, int state)
{
	if (state) {
		ctrlval &= !SDA;
	} else {
		ctrlval |= SDA;
	}
	outb_p(ctrlval, CTRL);
}


Local int bit_lpc_getscl(int minor)
{
	char i;
	i = 0 != ( inb_p(STAT) & SCLIN );	/* input inverted!	*/
	return i;
}


Local int bit_lpc_getsda(int minor)
{
	char i;
	i = 0 != ( inb_p(STAT) & SDAIN );	/* input inverted!	*/
	return i;
}


Local int bit_lpc_bit_init(int minor)
{
	if (check_region(i2c_table[minor].base,
		(i2c_table[minor].base == 0x3bc)? 3 : 8) < 0 ) {
		DEBE(printk("i2c_init: Port %#x already in use.\n",
			i2c_table[minor].base));
		return -ENODEV;
	} else {
		request_region(i2c_table[minor].base,
			(i2c_table[minor].base == 0x3bc)? 3 : 8,
			"i2c (lpc)");
		ctrlval = inb_p(i2c_table[minor].base);
		setsda(minor,1);
		setscl(minor,1);
	}
	printk("i2c%d: scl: %d     sda %d \n",minor,getscl(minor),getsda(minor));
	return 0;
}


Local void bit_lpc_bit_exit(int minor)
{	
	release_region( i2c_table[minor].base , 
		(i2c_table[minor].base == 0x3bc)? 3 : 8 );
}


/* ------------------------------------------------------------------------
 * Encapsulate the above functions in the correct operations structure.
 * This is only done when more than one hardware adapter is supported.
 */
#if (BITADAPS) > 1
struct i2c_bit_opns bit_lpc_ops = {
	bit_lpc_setscl,
	bit_lpc_setsda,
	bit_lpc_getscl,
	bit_lpc_getsda,
	bit_lpc_bit_init,
	bit_lpc_bit_exit
};
#endif
