/*
 * IceWM
 *
 * Copyright (C) 1998 Marko Macek
 */

#include "icewm.h"

YTimer::YTimer() {
    fRunning = 0;
    fPrev = fNext = 0;
    fInterval = 0;
    fListener = 0;
    app->registerTimer(this);
}

YTimer::~YTimer() {
    app->unregisterTimer(this);
}

void YTimer::startTimer() {
    gettimeofday(&timeout, 0);
    timeout.tv_usec += fInterval * 1000;
    while (timeout.tv_usec >= 1000000) {
        timeout.tv_usec -= 1000000;
        timeout.tv_sec++;
    }
    fRunning = true;
}

void YTimer::stopTimer() {
    fRunning = false;
}

