/* flags.c */
/* this file contains the functions used to manipulate flags */
/*
  gtkfind - a graphical "find" program
  Copyright (C) 1998  Matthew Grossman <mattg@oz.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include"flags.h"


#define MAX_FLAGS 256

static int flag_array[MAX_FLAGS] = {0};

int
set_flag(enum flag_t f, int value)
     /* set the flag f to value */
{
  int rv = 1;

  if(f >= MAX_FLAGS)
    rv = 0;
  else
    flag_array[(int)f] = value;
  
  return(rv);
}

int
get_flag(enum flag_t f)
     /* return the value of f */
{
  int rv = -1;

  rv = flag_array[(int)f];

  return(rv);
}

int
reset_flags()
     /* reset all flags that we want to reset to their default values */
{
  int rv = 0;
  int i = 0;

  for(i = 0; i < MAX_FLAGS; i++) {
    if(i == (int)SEARCH_SUBDIRS_P || i == (int)PRINT_TO_WINDOW_P ||
       i == (int)SHELL_COMMAND_P || i == (int)PRINT_TO_STDOUT_P ||
       i == (int)PRINT_FILENAME_ANYWAY_P || i == (int)WARNING_WINDOW_P ||
       i == (int)LONG_OUTPUT_P)
      /* do nothing */ ;
    else
      flag_array[i] = 0;
  }

  return(rv);
}
