/*  system.c -- Eterm secure system() replacement
 *           -- 21 August 1997, mej
 */

static const char *cvs_ident = "$Id: system.c,v 1.3 1998/10/13 22:41:39 mej Exp $";

#include "../config.h"
#include "feature.h"

#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <stdlib.h>
#include <signal.h>
#ifdef HAVE_SYS_WAIT_H
#  include <sys/wait.h>
#endif

#include "strings.h"
#include "options.h"
#include "screen.h"
#include "system.h"
#include "../libmej/debug.h"
#include "debug.h"

#ifndef ETERM_SYSTEM_WAIT_TIME
#  define ETERM_SYSTEM_WAIT_TIME 30
#endif

int system_wait(char *command);
int system_no_wait(char *command);

RETSIGTYPE
system_handle_alrm(int sig) {

  return;

}

RETSIGTYPE
system_handle_chld(int sig) {

  return;

}

/* Replace the system() call with a fork-and-exec that unprivs the child process */

int
system_wait(char *command) {

  char **cmd_argv;
  pid_t pid;
  register unsigned long i;
  int status = 0;
  sighandler_t prev_handler;

  cmd_argv = (char **) malloc(sizeof(char *) * (NumWords(command) + 1));

  for (i=0; (cmd_argv[i] = Word(i+1, command)); i++) {
#ifdef DEBUG_OPTIONS
    fprintf(stderr, "[debug] cmd_argv[%lu] == %s\n", i, cmd_argv[i]);
#endif
  }

  if (!(pid = fork())) {
    setreuid(my_ruid, my_ruid);
    setreuid(my_rgid, my_rgid);
    execvp(cmd_argv[0], cmd_argv);
    print_error("system_wait():  execvp(%s) failed -- %s", cmd_argv[0], strerror(errno));
    exit(EXIT_FAILURE);
  } else {
    prev_handler = signal(SIGALRM, system_handle_alrm);
    alarm(ETERM_SYSTEM_WAIT_TIME);
    waitpid(pid, &status, 0);
    alarm(0);
    signal(SIGALRM, prev_handler);
    if (WIFEXITED(status)) {
      i = WEXITSTATUS(status);
#ifdef DEBUG_OPTIONS
      fprintf(stderr, "[debug] system_wait():  Child process exited with return code %lu\n",
	      i);
#endif
    } else if (WIFSIGNALED(status)) {
      i = WTERMSIG(status);
#ifdef DEBUG_OPTIONS
      fprintf(stderr, "[debug] system_wait():  Child process was terminated by unhandled "
	      "signal %lu\n", i);
#endif
    }
  }
  return ((int) i);
}

int
system_no_wait(char *command) {

  char **cmd_argv;
  pid_t pid;
  register unsigned long i;

  cmd_argv = (char **) malloc(sizeof(char *) * (NumWords(command) + 1));

  for (i=0; (cmd_argv[i] = Word(i+1, command)); i++) {
#ifdef DEBUG_OPTIONS
    fprintf(stderr, "[debug] cmd_argv[%lu] == %s\n", i, cmd_argv[i]);
#endif
  }

  if (!(pid = fork())) {
    setreuid(my_ruid, my_ruid);
    setreuid(my_rgid, my_rgid);
    execvp(cmd_argv[0], cmd_argv);
    print_error("system_wait():  execvp(%s) failed -- %s", cmd_argv[0], strerror(errno));
    exit(EXIT_FAILURE);
  }

  return (0);
}

