#include "E.h"

void
HandleFocusWindow(Window win)
{
   EWin               *found_ewin;
   char                isclient;

   EDBUG(5, "HandleFocusWindow");
   found_ewin = FindEwinByChildren(win);
   isclient = 0;
   if (mode.focusmode == FOCUS_CLICK)
     {
	if (found_ewin)
	  {
	     if (GetEwinPointerInClient())
		isclient = 1;
	     if (((found_ewin) && (found_ewin != mode.mouse_over_win)) ||
		 (isclient))
	       {
		  if (found_ewin != mode.focuswin)
		    {
		       GrabTheButtons(root.win);
		    }
	       }
	     else
	       {
		  UnGrabTheButtons();
	       }
	     mode.mouse_over_win = found_ewin;
	  }
     }
   else if (mode.focusmode == FOCUS_SLOPPY)
     {
	if (found_ewin != mode.focuswin)
	  {
	     if (found_ewin)
		FocusToEWin(found_ewin);
	  }
	mode.mouse_over_win = found_ewin;
     }
   else if (mode.focusmode == FOCUS_POINTER)
     {
	if (!found_ewin)
	   found_ewin = GetEwinPointerInClient();
	if (found_ewin != mode.focuswin)
	   FocusToEWin(found_ewin);
	mode.mouse_over_win = found_ewin;
     }
   EDBUG_RETURN_;
}

void
HandleChildShapeChange(XEvent * ev)
{
   Window              win;
   EWin               *ewin;
   Border             *b;

   EDBUG(5, "HandleChildShapeChange");
   win = ((XShapeEvent *) ev)->window;
   ewin = FindItem(NULL, win, LIST_FINDBY_ID, LIST_TYPE_EWIN);
   if (ewin)
     {
	b = ewin->border;
	SyncBorderToEwin(ewin);
	if (ewin->border == b)
	   PropagateShapes(ewin->win);
     }
   EDBUG_RETURN_;
}

void
HandleMotion(XEvent * ev)
{
   int                 dx, dy;
   int                 pw, ph;
   int                 x, y, w, h;
   EWin               *ewin;

   EDBUG(5, "HandleMotion");
   mode.px = mode.x;
   mode.py = mode.y;
   mode.x = ev->xmotion.x_root;
   mode.y = ev->xmotion.y_root;
   ewin = NULL;
   desks.current = DekstopAt(mode.x, mode.y);

   if (!(ev->xmotion.state & (Button1Mask | Button2Mask |
			      Button3Mask | Button4Mask |
			      Button5Mask)))
     {
	switch (mode.mode)
	  {
	  case MODE_RESIZE:
	  case MODE_RESIZE_H:
	  case MODE_RESIZE_V:
	     doResizeEnd(NULL);
	     break;
	  case MODE_MOVE:
	     doMoveEnd(NULL);
	     break;
	  case MODE_BUTTONDRAG:
	     doDragButtonEnd(NULL);
	     break;
	  default:
	     break;
	  }
	EDBUG_RETURN_;
     }
   switch (mode.mode)
     {
     case MODE_MOVE:
	if (mode.ewin)
	  {
	     ewin = mode.ewin;
	     dx = mode.x - mode.px;
	     dy = mode.y - mode.py;
	     if (mode.movemode == 0)
	       {
		  char                dofloat = 0;

		  if ((ewin->desktop != 0) && (!ewin->floating) && (!ewin->sticky))
		    {
		       if (DekstopAt(desks.desk[ewin->desktop].x + ewin->x + dx,
				     desks.desk[ewin->desktop].y + ewin->y + dy) != ewin->desktop)
			  dofloat = 1;
		       else if (DekstopAt(desks.desk[ewin->desktop].x + ewin->x + dx + ewin->w,
					  desks.desk[ewin->desktop].y + ewin->y + dy) != ewin->desktop)
			  dofloat = 1;
		       else if (DekstopAt(desks.desk[ewin->desktop].x + ewin->x + dx + ewin->w,
					  desks.desk[ewin->desktop].y + ewin->y + dy + ewin->h) != ewin->desktop)
			  dofloat = 1;
		       else if (DekstopAt(desks.desk[ewin->desktop].x + ewin->x + dx,
					  desks.desk[ewin->desktop].y + ewin->y + dy + ewin->h) != ewin->desktop)
			  dofloat = 1;
		       if (dofloat)
			  FloatEwinAt(ewin, ewin->x + desks.desk[ewin->desktop].x,
				      ewin->y + desks.desk[ewin->desktop].y);
		    }
	       }
	     DrawEwinShape(ewin, mode.movemode, ewin->x + dx, ewin->y + dy,
			   ewin->client.w, ewin->client.h, mode.firstlast);
	  }
	break;
     case MODE_RESIZE:
	if (mode.ewin)
	  {
	     ewin = mode.ewin;
	     switch (mode.resize_detail)
	       {
	       case 0:
		  pw = ewin->client.w;
		  ph = ewin->client.h;
		  w = mode.win_w - (mode.x - mode.start_x);
		  h = mode.win_h - (mode.y - mode.start_y);
		  x = mode.win_x + (mode.x - mode.start_x);
		  y = mode.win_y + (mode.y - mode.start_y);
		  ewin->client.w = w;
		  ewin->client.h = h;
		  ICCCM_MatchSize(ewin);
		  w = ewin->client.w;
		  h = ewin->client.h;
		  if (pw == ewin->client.w)
		     x = ewin->x;
		  else
		     x = mode.win_x + mode.win_w - w;
		  if (ph == ewin->client.h)
		     y = ewin->y;
		  else
		     y = mode.win_y + mode.win_h - h;
		  ewin->client.w = pw;
		  ewin->client.h = ph;
		  DrawEwinShape(ewin, mode.resizemode, x, y, w, h, mode.firstlast);
		  break;
	       case 1:
		  ph = ewin->client.h;
		  w = mode.win_w + (mode.x - mode.start_x);
		  h = mode.win_h - (mode.y - mode.start_y);
		  x = ewin->x;
		  y = mode.win_y + (mode.y - mode.start_y);
		  ewin->client.h = h;
		  ICCCM_MatchSize(ewin);
		  h = ewin->client.h;
		  if (ph == ewin->client.h)
		     y = ewin->y;
		  else
		     y = mode.win_y + mode.win_h - h;
		  ewin->client.h = ph;
		  DrawEwinShape(ewin, mode.resizemode, x, y, w, h, mode.firstlast);
		  break;
	       case 2:
		  pw = ewin->client.w;
		  w = mode.win_w - (mode.x - mode.start_x);
		  h = mode.win_h + (mode.y - mode.start_y);
		  x = mode.win_x + (mode.x - mode.start_x);
		  y = ewin->y;
		  ewin->client.w = w;
		  ICCCM_MatchSize(ewin);
		  w = ewin->client.w;
		  if (pw == ewin->client.w)
		     x = ewin->x;
		  else
		     x = mode.win_x + mode.win_w - w;
		  ewin->client.w = pw;
		  DrawEwinShape(ewin, mode.resizemode, x, y, w, h, mode.firstlast);
		  break;
	       case 3:
		  w = mode.win_w + (mode.x - mode.start_x);
		  h = mode.win_h + (mode.y - mode.start_y);
		  x = ewin->x;
		  y = ewin->y;
		  DrawEwinShape(ewin, mode.resizemode, x, y, w, h, mode.firstlast);
		  break;
	       default:
		  break;
	       }
	  }
	break;
     case MODE_RESIZE_H:
	if (mode.ewin)
	  {
	     ewin = mode.ewin;
	     switch (mode.resize_detail)
	       {
	       case 0:
		  pw = ewin->client.w;
		  w = mode.win_w - (mode.x - mode.start_x);
		  h = ewin->client.h;
		  x = mode.win_x + (mode.x - mode.start_x);
		  y = ewin->y;
		  ewin->client.w = w;
		  ICCCM_MatchSize(ewin);
		  w = ewin->client.w;
		  if (pw == ewin->client.w)
		     x = ewin->x;
		  else
		     x = mode.win_x + mode.win_w - w;
		  ewin->client.w = pw;
		  DrawEwinShape(ewin, mode.resizemode, x, y, w, h, mode.firstlast);
		  break;
	       case 1:
		  w = mode.win_w + (mode.x - mode.start_x);
		  h = ewin->client.h;
		  x = ewin->x;
		  y = ewin->y;
		  DrawEwinShape(ewin, mode.resizemode, x, y, w, h, mode.firstlast);
		  break;
	       default:
		  break;
	       }
	  }
	break;
     case MODE_RESIZE_V:
	if (mode.ewin)
	  {
	     ewin = mode.ewin;
	     switch (mode.resize_detail)
	       {
	       case 0:
		  ph = ewin->client.h;
		  w = ewin->client.w;
		  h = mode.win_h - (mode.y - mode.start_y);
		  x = ewin->x;
		  y = mode.win_y + (mode.y - mode.start_y);
		  ewin->client.h = h;
		  ICCCM_MatchSize(ewin);
		  h = ewin->client.h;
		  if (ph == ewin->client.h)
		     y = ewin->y;
		  else
		     y = mode.win_y + mode.win_h - h;
		  ewin->client.h = ph;
		  DrawEwinShape(ewin, mode.resizemode, x, y, w, h, mode.firstlast);
		  break;
	       case 1:
		  w = ewin->client.w;
		  h = mode.win_h + (mode.y - mode.start_y);
		  x = ewin->x;
		  y = ewin->y;
		  DrawEwinShape(ewin, mode.resizemode, x, y, w, h, mode.firstlast);
		  break;
	       default:
		  break;
	       }
	  }
	break;
     case MODE_DESKDRAG:
	dx = mode.x - mode.px;
	dy = mode.y - mode.py;
	switch (desks.dragdir)
	  {
	  case 0:
	     if ((desks.desk[mode.deskdrag].x + dx) < 0)
		dx = -desks.desk[mode.deskdrag].x;
	     MoveDesktop(mode.deskdrag, desks.desk[mode.deskdrag].x + dx,
			 desks.desk[mode.deskdrag].y);
	     break;
	  case 1:
	     if ((desks.desk[mode.deskdrag].x + dx) > 0)
		MoveDesktop(mode.deskdrag, 0, desks.desk[mode.deskdrag].y);
	     else
		MoveDesktop(mode.deskdrag, desks.desk[mode.deskdrag].x + dx,
			    desks.desk[mode.deskdrag].y);
	     break;
	  case 2:
	     if ((desks.desk[mode.deskdrag].y + dy) < 0)
		dy = -desks.desk[mode.deskdrag].y;
	     MoveDesktop(mode.deskdrag, desks.desk[mode.deskdrag].x,
			 desks.desk[mode.deskdrag].y + dy);
	     break;
	  case 3:
	     if ((desks.desk[mode.deskdrag].y + dy) > 0)
		MoveDesktop(mode.deskdrag, desks.desk[mode.deskdrag].x, 0);
	     else
		MoveDesktop(mode.deskdrag, desks.desk[mode.deskdrag].x,
			    desks.desk[mode.deskdrag].y + dy);
	     break;
	  default:
	     break;
	  }
	break;
     case MODE_BUTTONDRAG:
	dx = mode.x - mode.px;
	dy = mode.y - mode.py;
	if (mode.button_move_pending)
	  {
	     x = mode.x - mode.start_x;
	     y = mode.y - mode.start_y;
	     if (x < 0)
		x = -x;
	     if (y < 0)
		y = -y;
	     if ((x > mode.button_move_resistance) ||
		 (y > mode.button_move_resistance))
		mode.button_move_pending = 0;
	  }
	if (!mode.button_move_pending)
	  {
	     if (mode.button)
	       {
		  MovebuttonToCoord(mode.button,
				    mode.button->x + dx,
				    mode.button->y + dy);
		  if (mode.deskmode == MODE_DESKRAY)
		    {
		       MoveDesktop(mode.deskdrag, desks.desk[mode.deskdrag].x,
				   desks.desk[mode.deskdrag].y + dy);
		    }
	       }
	  }
	break;
     default:
	break;
     }
   EDBUG_RETURN_;
}

void
HandleDestroy(XEvent * ev)
{
   Window              win;
   EWin               *ewin;
   Client             *c;

   EDBUG(5, "HandleDestroy");
   win = ev->xunmap.window;
   ewin = RemoveItem(NULL, win, LIST_FINDBY_ID, LIST_TYPE_EWIN);
   if (ewin)
     {
	if (ewin == mode.ewin)
	  {
	     switch (mode.mode)
	       {
	       case MODE_RESIZE:
	       case MODE_RESIZE_H:
	       case MODE_RESIZE_V:
		  doResizeEnd(NULL);
		  break;
	       case MODE_MOVE:
		  doMoveEnd(NULL);
		  break;
	       default:
		  break;
	       }
	  }
	if (mode.doingslide)
	  {
	     DrawEwinShape(ewin, mode.slidemode, ewin->x, ewin->y, ewin->client.w, ewin->client.h, 2);
	     mode.doingslide = 0;
	  }
	if (ewin == mode.focuswin)
	   FocusToEWin(NULL);
	if (ewin == mode.mouse_over_win)
	   mode.mouse_over_win = NULL;
	if (ewin == mode.ewin)
	   mode.ewin = NULL;
	FreeEwin(ewin);
	EDBUG_RETURN_;
     }
   c = FindItem(NULL, win, LIST_FINDBY_ID, LIST_TYPE_CLIENT);
   if (c)
      DeleteClient(c);
   EDBUG_RETURN_;
}

void
HandleProperty(XEvent * ev)
{
   Window              win;
   EWin               *ewin;

   EDBUG(5, "HandleProperty");
   win = ev->xproperty.window;
   ewin = FindItem(NULL, win, LIST_FINDBY_ID, LIST_TYPE_EWIN);
   if (ewin)
     {
	ICCCM_GetColormap(ewin);
	SyncBorderToEwin(ewin);
     }
   EDBUG_RETURN_;
}

void
HandleCirculate(XEvent * ev)
{
   Window              win;
   EWin               *ewin;

   EDBUG(5, "HandleCirculate");
   win = ev->xcirculaterequest.window;
   ewin = FindItem(NULL, win, LIST_FINDBY_ID, LIST_TYPE_EWIN);
   if (ewin)
     {
	if (ev->xcirculaterequest.place == PlaceOnTop)
	   RaiseEwin(ewin);
	else
	   LowerEwin(ewin);
     }
   else
     {
	if (ev->xcirculaterequest.place == PlaceOnTop)
	   XRaiseWindow(disp, win);
	else
	   XLowerWindow(disp, win);
     }
   EDBUG_RETURN_;
}

void
HandleReparent(XEvent * ev)
{
   Window              par;
   EWin               *ewin, *ewin2;
   void              **lst;
   int                 i, num, found = 0;

   EDBUG(5, "HandleReparent");
   par = ev->xreparent.window;
   EDBUG_RETURN_;
   ewin = FindItem(NULL, ev->xreparent.window, LIST_FINDBY_ID, LIST_TYPE_EWIN);
   if (!ewin)
      EDBUG_RETURN_;
   lst = ListItemType(&num, LIST_TYPE_EWIN);
   if ((lst) && (num > 0))
     {
	for (i = 0; i < num; i++)
	  {
	     ewin2 = (EWin *) lst[i];
	     if (ewin2->win == ev->xreparent.parent)
		found = 1;
	  }
	Efree(lst);
     }
   if (!found)
     {
	ewin = RemoveItem(NULL, ev->xreparent.window, LIST_FINDBY_ID, LIST_TYPE_EWIN);
	if (ewin)
	  {
	     if (ewin == mode.ewin)
	       {
		  switch (mode.mode)
		    {
		    case MODE_RESIZE:
		    case MODE_RESIZE_H:
		    case MODE_RESIZE_V:
		       doResizeEnd(NULL);
		       break;
		    case MODE_MOVE:
		       doMoveEnd(NULL);
		       break;
		    default:
		       break;
		    }
	       }
	     ewin->client.win = 0;
	     FreeEwin(ewin);
	  }
     }
   EDBUG_RETURN_;
}

void
HandleConfigureRequest(XEvent * ev)
{
   Window              win, winrel;
   EWin               *ewin, *ewin2;
   int                 x = 0, y = 0, w = 0, h = 0;
   int                 move = 0, resize = 0;
   XWindowChanges      xwc;

   EDBUG(5, "HandleConfigureRequest");
   win = ev->xconfigurerequest.window;
   ewin = FindItem(NULL, win, LIST_FINDBY_ID, LIST_TYPE_EWIN);
   if (ewin)
     {
	x = ewin->x;
	y = ewin->y;
	w = ewin->client.w;
	h = ewin->client.h;
	winrel = 0;
	if (ev->xconfigurerequest.value_mask & CWX)
	  {
	     x = ev->xconfigurerequest.x;
	     move = 1;
	  }
	if (ev->xconfigurerequest.value_mask & CWY)
	  {
	     y = ev->xconfigurerequest.y;
	     move = 1;
	  }
	if (ev->xconfigurerequest.value_mask & CWWidth)
	  {
	     w = ev->xconfigurerequest.width;
	     resize = 1;
	  }
	if (ev->xconfigurerequest.value_mask & CWHeight)
	  {
	     h = ev->xconfigurerequest.height;
	     resize = 1;
	  }
	if (ev->xconfigurerequest.value_mask & CWSibling)
	  {
	     winrel = ev->xconfigurerequest.above;
	  }
	if (ev->xconfigurerequest.value_mask & CWStackMode)
	  {
	     ewin2 = FindItem(NULL, winrel, LIST_FINDBY_ID, LIST_TYPE_EWIN);
	     if (ewin2)
		winrel = ewin2->win;
	     xwc.sibling = winrel;
	     xwc.stack_mode = ev->xconfigurerequest.detail;
	     if (xwc.stack_mode == Above)
		RaiseEwin(ewin);
	     else if (xwc.stack_mode == Below)
		LowerEwin(ewin);
	     else
		XConfigureWindow(disp, ewin->win,
				 ev->xconfigurerequest.value_mask &
				 (CWSibling | CWStackMode), &xwc);
	  }
	if ((move) && (resize))
	   MoveResizeEwin(ewin, x, y, w, h);
	else if (move)
	  {
	     MoveEwin(ewin, x, y);
	     ICCCM_Configure(ewin);
	  }
	else if (resize)
	   ResizeEwin(ewin, w, h);
     }
   else
     {
	xwc.x = ev->xconfigurerequest.x;
	xwc.y = ev->xconfigurerequest.y;
	xwc.width = ev->xconfigurerequest.width;
	xwc.height = ev->xconfigurerequest.height;
	xwc.border_width = ev->xconfigurerequest.border_width;
	xwc.sibling = ev->xconfigurerequest.above;
	xwc.stack_mode = ev->xconfigurerequest.detail;
	XConfigureWindow(disp, win, ev->xconfigurerequest.value_mask, &xwc);
     }
   EDBUG_RETURN_;
}

void
HandleResizeRequest(XEvent * ev)
{
   Window              win;
   EWin               *ewin;
   int                 w, h;

   EDBUG(5, "HandleResizeRequest");
   win = ev->xresizerequest.window;
   ewin = FindItem(NULL, win, LIST_FINDBY_ID, LIST_TYPE_EWIN);
   if (ewin)
     {
	w = ev->xresizerequest.width;
	h = ev->xresizerequest.height;
	ResizeEwin(ewin, w, h);
     }
   else
      XResizeWindow(disp, win, ev->xresizerequest.width, ev->xresizerequest.height);
   EDBUG_RETURN_;
}

void
HandleUnmap(XEvent * ev)
{
   Window              win;
   EWin               *ewin;

   EDBUG(5, "HandleUnmap");
   win = ev->xunmap.window;
   ewin = RemoveItem(NULL, win, LIST_FINDBY_ID, LIST_TYPE_EWIN);
   if (ewin)
     {
	if (ewin == mode.ewin)
	  {
	     switch (mode.mode)
	       {
	       case MODE_RESIZE:
	       case MODE_RESIZE_H:
	       case MODE_RESIZE_V:
		  doResizeEnd(NULL);
		  break;
	       case MODE_MOVE:
		  doMoveEnd(NULL);
		  break;
	       default:
		  break;
	       }
	  }
	if (ewin == mode.focuswin)
	   FocusToEWin(NULL);
	if (ewin == mode.mouse_over_win)
	   mode.mouse_over_win = NULL;
	if (ewin == mode.ewin)
	   mode.ewin = NULL;
	XRemoveFromSaveSet(disp, ewin->client.win);
	XReparentWindow(disp, ewin->client.win, root.win,
			ewin->client.x, ewin->client.y);
	FreeEwin(ewin);
     }
   EDBUG_RETURN_;
}

void
HandleMapRequest(XEvent * ev)
{
   EDBUG(5, "HandleMapRequest");
   AddToFamily(ev->xmap.window);
   EDBUG_RETURN_;
}

void
HandleExpose(XEvent * ev)
{
   Window              win;
   EWin               *ewin;
   int                 i;
   List               *ptr;

   EDBUG(5, "HandleExpose");
   if (ev->xexpose.count > 0)
      EDBUG_RETURN_;
   win = ev->xexpose.window;
   ptr = lists.next;

   while (ptr)
     {
	if (ptr->type == LIST_TYPE_EWIN)
	  {
	     ewin = (EWin *) ptr->item;
	     for (i = 0; i < ewin->border->num_winparts; i++)
		if (win == ewin->bits[i].win)
		  {
		     ewin->bits[i].expose = 1;
		     DrawEwinWinpart(ewin, i);
		     EDBUG_RETURN_;
		  }
	  }
	ptr = ptr->next;
     }
   EDBUG_RETURN_;
}

void
HandleMouseDown(XEvent * ev)
{
   Window              win;
   EWin               *ewin;
   int                 i;
   List               *ptr;
   Button             *b;
   ActionClass        *ac;

   EDBUG(5, "HandleMouseDown");
   win = ev->xbutton.window;
   ptr = lists.next;

   mode.x = ev->xbutton.x_root;
   mode.y = ev->xbutton.y_root;

   if (mode.focusmode == FOCUS_CLICK)
     {
	Window              rt, ch;
	int                 dum;
	int                 d;

	d = DekstopAt(mode.x, mode.y) & 0x31;
	XQueryPointer(disp, desks.desk[d].win, &rt, &ch, &dum, &dum, &dum,
		      &dum, (unsigned int *)&dum);
	ewin = FindEwinByBase(ch);
	if (mode.click_focus_grabbed)
	  {
	     XEvent              xev;

	     UnGrabTheButtons();
	     XTestFakeButtonEvent(disp, ev->xbutton.button, True, CurrentTime);
	     if (XCheckMaskEvent(disp, ButtonReleaseMask, &xev))
		XTestFakeButtonEvent(disp, xev.xbutton.button, False,
				     CurrentTime);
	  }
	FocusToEWin(ewin);
	if (ewin)
	   RaiseEwin(ewin);
     }
   while (ptr)
     {
	if (ptr->type == LIST_TYPE_EWIN)
	  {
	     ewin = (EWin *) ptr->item;
	     for (i = 0; i < ewin->border->num_winparts; i++)
		if (win == ewin->bits[i].win)
		  {
		     mode.ewin = ewin;
		     ewin->bits[i].state = STATE_CLICKED;
		     ChangeEwinWinpart(ewin, i);
		     if (ewin->border->part[i].aclass)
			EventAclass(ev, ewin->border->part[i].aclass);
		     EDBUG_RETURN_;
		  }
	  }
	else if (ptr->type == LIST_TYPE_BUTTON)
	  {
	     b = (Button *) ptr->item;
	     if (win == b->win)
	       {
		  mode.button = b;
		  b->state = STATE_CLICKED;
		  DrawButon(b);
		  ac = FindItem("ACTION_BUTTON_DRAG", 0, LIST_FINDBY_NAME,
				LIST_TYPE_ACLASS);
		  if (ac)
		     EventAclass(ev, ac);
		  if (b->aclass)
		     EventAclass(ev, b->aclass);
	       }
	  }
	ptr = ptr->next;
     }
   EDBUG_RETURN_;
}

void
HandleMouseUp(XEvent * ev)
{
   Window              win;
   EWin               *ewin;
   int                 i;
   List               *ptr;
   Button             *b;
   char                wasdrag;

   EDBUG(5, "HandleMouseUp");
   win = ev->xbutton.window;
   ptr = lists.next;
   wasdrag = 0;

   if (mode.mode == MODE_DESKDRAG)
      mode.mode = MODE_NONE;
   if (mode.mode == MODE_BUTTONDRAG)
     {
	if (!mode.button_move_pending)
	   wasdrag = 1;
	doDragButtonEnd(NULL);
     }
   while (ptr)
     {
	if (ptr->type == LIST_TYPE_EWIN)
	  {
	     ewin = (EWin *) ptr->item;
	     for (i = 0; i < ewin->border->num_winparts; i++)
		if (win == ewin->bits[i].win)
		  {
		     if (ewin == mode.ewin)
		       {
			  switch (mode.mode)
			    {
			    case MODE_RESIZE:
			    case MODE_RESIZE_H:
			    case MODE_RESIZE_V:
			       doResizeEnd(NULL);
			       break;
			    case MODE_MOVE:
			       doMoveEnd(NULL);
			       break;
			    default:
			       break;
			    }
		       }
		     if (ewin->bits[i].state == STATE_CLICKED)
			ewin->bits[i].state = STATE_HILITED;
		     else
			ewin->bits[i].state = STATE_NORMAL;
		     ChangeEwinWinpart(ewin, i);
		     if (ewin->border->part[i].aclass)
			EventAclass(ev, ewin->border->part[i].aclass);
		     EDBUG_RETURN_;
		  }
	  }
	else if (ptr->type == LIST_TYPE_BUTTON)
	  {
	     b = (Button *) ptr->item;
	     if (win == b->win)
	       {
		  mode.button = b;
		  if (b->state == STATE_CLICKED)
		     b->state = STATE_HILITED;
		  else
		     b->state = STATE_NORMAL;
		  DrawButon(b);
		  if ((b->aclass) && (!wasdrag))
		     EventAclass(ev, b->aclass);
	       }
	  }
	ptr = ptr->next;
     }
   switch (mode.mode)
     {
     case MODE_RESIZE:
     case MODE_RESIZE_H:
     case MODE_RESIZE_V:
	doResizeEnd(NULL);
	break;
     case MODE_MOVE:
	ewin = GetEwin();
	if ((mode.movemode == 0) && (ewin) && (mode.mode == MODE_MOVE))
	  {
	     char                dofloat = 0;

	     if ((ewin->desktop != 0) && (!ewin->floating) && (!ewin->sticky))
	       {
		  if (DekstopAt(desks.desk[ewin->desktop].x + ewin->x,
		      desks.desk[ewin->desktop].y + ewin->y) != ewin->desktop)
		     dofloat = 1;
		  else if (DekstopAt(desks.desk[ewin->desktop].x + ewin->x + ewin->w,
		      desks.desk[ewin->desktop].y + ewin->y) != ewin->desktop)
		     dofloat = 1;
		  else if (DekstopAt(desks.desk[ewin->desktop].x + ewin->x + ewin->w,
				     desks.desk[ewin->desktop].y + ewin->y + ewin->h) != ewin->desktop)
		     dofloat = 1;
		  else if (DekstopAt(desks.desk[ewin->desktop].x + ewin->x,
				     desks.desk[ewin->desktop].y + ewin->y + ewin->h) != ewin->desktop)
		     dofloat = 1;
		  if (dofloat)
		     FloatEwinAt(ewin, ewin->x + desks.desk[ewin->desktop].x,
				 ewin->y + desks.desk[ewin->desktop].y);
	       }
	  }
	doMoveEnd(NULL);
	break;
     default:
	break;
     }
   EDBUG_RETURN_;
}

void
HandleMouseIn(XEvent * ev)
{
   Window              win;
   EWin               *ewin;
   int                 i;
   List               *ptr;
   Button             *b;

   EDBUG(5, "HandleMouseIn");
   win = ev->xbutton.window;
   ptr = lists.next;

   while (ptr)
     {
	if (ptr->type == LIST_TYPE_EWIN)
	  {
	     ewin = (EWin *) ptr->item;
	     for (i = 0; i < ewin->border->num_winparts; i++)
		if (win == ewin->bits[i].win)
		  {
		     mode.noewin = 0;
		     mode.ewin = ewin;
		     ewin->bits[i].state = STATE_HILITED;
		     ChangeEwinWinpart(ewin, i);
		     if (ewin->border->part[i].aclass)
			EventAclass(ev, ewin->border->part[i].aclass);
		     EDBUG_RETURN_;
		  }
	  }
	else if (ptr->type == LIST_TYPE_BUTTON)
	  {
	     b = (Button *) ptr->item;
	     if (win == b->win)
	       {
		  mode.button = b;
		  b->state = STATE_HILITED;
		  DrawButon(b);
		  if (b->aclass)
		     EventAclass(ev, b->aclass);
	       }
	  }
	ptr = ptr->next;
     }
   EDBUG_RETURN_;
}

void
HandleMouseOut(XEvent * ev)
{
   Window              win;
   EWin               *ewin;
   int                 i;
   List               *ptr;
   Button             *b;

   EDBUG(5, "HandleMouseOut");
   win = ev->xbutton.window;
   ptr = lists.next;

   while (ptr)
     {
	if (ptr->type == LIST_TYPE_EWIN)
	  {
	     ewin = (EWin *) ptr->item;
	     for (i = 0; i < ewin->border->num_winparts; i++)
		if (win == ewin->bits[i].win)
		  {
		     if (mode.mode == MODE_NONE)
			mode.ewin = NULL;
		     else
			mode.noewin = 1;
		     ewin->bits[i].state = STATE_NORMAL;
		     ChangeEwinWinpart(ewin, i);
		     if (ewin->border->part[i].aclass)
			EventAclass(ev, ewin->border->part[i].aclass);
		     EDBUG_RETURN_;
		  }
	  }
	else if (ptr->type == LIST_TYPE_BUTTON)
	  {
	     b = (Button *) ptr->item;
	     if (win == b->win)
	       {
		  mode.button = NULL;
		  b->state = STATE_NORMAL;
		  DrawButon(b);
		  if (b->aclass)
		     EventAclass(ev, b->aclass);
	       }
	  }
	ptr = ptr->next;
     }
   EDBUG_RETURN_;
}
