//<copyright>
//
// Copyright (c) 1996,97
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        bspdraw.C
//
// Purpose:     drawing routines of BSP Tree
//
// Created:     26 Feb 96  Georg Meszaros
//
// Changed:      7 Jan 97  Michael Pichler
//
// $Id: bspdraw.C,v 1.6 1997/02/25 16:59:31 mpichler Exp $
//
//</file>


#include "camera.h"
#include "scene3d.h"
#include "vrmlscene.h"
#include "vecutil.h"

#include "bsptree.h"
#include "svbsptree.h"

#include <ge3d/ge3d.h>



void VRMLScene::drawBSPTree()
{

//cerr << "*:VRMLScene::drawBSPTree\n";
  
  // 1:enable backfaceculling
  // TODO: manually in the rendering algorithm, bsptree->drawBackToFront,...
  ge3dHint(hint_backfaceculling, 0);

  // VRMLScene::draw sets default colour back to white, etc, ...
  // to check in Face::draw if there was a change in the settings
  bsp_root_->resetAttributes();

  // position is the COP, the eye of the camera
  point3D position;
  camera_->getposition(position);  

  // TODO: delete the setting here (set via menu)
  //bsp_mode_ = BSP_PLAIN;
  //bsp_mode_ = BSP_BACK_FACE_CULLING;
  //bsp_mode_ = BSP_SHADOW_VOLUME;

  int new_visibility_calc;
  if (!frames_to_render_)
  {
     frames_to_render_ = (int) frame_tolerance_;
     new_visibility_calc = 1;
  }
  else 
  {
     new_visibility_calc = 0;
     frames_to_render_--;
  }

  if ((bsp_mode_ == BSP_SHADOW_VOLUME) && new_visibility_calc) 
  {
    // the svbsp-tree root
    SVBSPTree* svbsp_root = new SVBSPTree(position, area_margin_, first_x_polygons_, bsp_root_);

    svbsp_root->insertViewVolume(camera_);

    bsp_root_->buildSVBSPTree (svbsp_root, (BSPMode) bsp_mode_);

    //cerr << "Nodes in the SVBSP-Tree: " << svbsp_root->nodeNumber() << "\n";

    scene_->showBSPInfo(svbsp_root->visible_face_count_,
                        svbsp_root->hidden_face_count_,
                        svbsp_root->back_face_count_);
    //cout << svbsp_root->visible_split_face_count_ << 
//          " actual (split) faces drawn in front to back order\n";
 
    delete svbsp_root;
  }
  if (bsp_mode_ != BSP_SHADOW_VOLUME) scene_->showBSPInfo();

  if (scene_->front2backDrawing ())
    bsp_root_->drawFrontToBack(position, (BSPMode) bsp_mode_);
  else
    bsp_root_->drawBackToFront(position, (BSPMode) bsp_mode_);

//cerr << "finished " << test++ << "\n";


} // drawBackToFront
