#ifndef ACCONFIG_H
#define ACCONFIG_H 1

/*
** Configuration file for Hypermail 
**
*/

/* User-definable options are below */

/*
** Define as the default title you want to call your archives.
** Define as "NONE" to use the name of the input mailbox.
*/
#define LABEL "NONE"

/* 
** This is the default directory that new files are put into and
** that existing files are read from. If defined as "NONE", this
** will be the name of the input mailbox.
*/
#define DIR "NONE"

/*
** Define MBOX as "NONE" to read from standard input.
*/
#define MBOX "NONE"

/*
** This should be a URL of some type. Define ARCHIVES as "NONE" 
** to omit a link to other archives.
*/
#define ARCHIVES "NONE"

/*
** This should be a URL of some type. Define ABOUT as "NONE"
** to omit a link to archive information.
*/
#define ABOUT "NONE"

/* 
** Define as the configuration file to read settings from. ~ as the first
** character represents the current user's home directory. Define as
** "NONE" for no configuration file.
*/
#define CONFIGFILE "~/.hmrc"

/* 
** Define as the default main index that users see when the archive
** is first accessed. Possible values are "date", "subject", "author", and
** "thread".
*/
#define DEFAULTINDEX "thread"

/*
** Define as 0 if you want latest message on the bottom for date and
** thread indexes. Else define as 1 to put recent messages on top.
*/
#define REVERSE 0

/*
** Define as 0 if you want to hide mail headers in messages.
** Else define as 1.
*/
#define SHOWHEADERS 0

/*
** This lets you list the RFC 822 headers you want to show if you turn 
** showheaders on.  They can be listed comma or space separated.
*/
#define SHOW_HEADERS "From,Subject,Date,Message-ID"

/*
** Define as 0 if you want messages to be shown in a proportional font.
** Else define as 1.
*/
#define SHOWHTML 1

/*
** Define if you want article lines to end with the <br> tag.
** Else uncomment to have non-quoted lines word-wrap. Only takes effect
** if SHOWHTML is defined.
*/
#define SHOWBR 1

/*
** Define if you want quoted lines to be shown in italics. Only
** take effect if SHOWHTML is defined.
*/
#define IQUOTES 1

/*
** Define if you want to recognize Supercite-style lines in the form
** "  Jane> <text>" as quoted lines.  Only takes effect if IQUOTES
** is defined.
*/
#define RECOGNIZE_SUPERCITE_QUOTES 

/*
** Define if you want horizontal rules before and after messages.
*/
#define SHOWHR 1

/* 
** Define if you want to use a table format for the index menu.
*/
#define USETABLE 0
  
/* 
** Define if you want links to article replies in messages.
*/
#define SHOWREPLIES 0
  
/*
** Define if you want links to Next, Prev, Next thread, Reply to, etc.
*/
#define SHOW_MSG_LINKS 1

/*
** Define as 0 to always overwrite existing files. Define as 1 to
** only write files that are new.
*/
#define OVERWRITE 0

/* 
** Define as 1 to read in one article only and update existing archives.
** Define as 0 for normal operation.
*/
#define INCREMENT 0

/* 
** Define as 1 to show progress as Hypermail works. Define as 0 for silent
** operation.
*/
#define PROGRESS 0

/* 
** Define as the permissions mode to change any created directories to.
** This must be an octal number.
*/
#define DIRMODE 0755

/* 
** Define as the permissions mode to change any created HTML files to.
** This must be an octal number.
*/
#define FILEMODE 0644

/* 
** Define as the number of thread level indents to show in the thread
** index file. The normal value is 2.
*/
#define THRDLEVELS 2

/*
** Define to reflect how you want dates in the index files.
** Define as 1 to to use European date format "DD MM YYYY".
** Define as 0 to to use American date format "MM DD YYYY".
*/
#define EURODATE 0

/*
** This is the mail command that email links go to, for instance
** "mailto:$TO" or "/cgi-bin/mail?to=$TO".
**
** In constructing this command, you can specify variables:
**
** $TO : the email address of the person you're sending mail to.
** $ID : the ID of the message you're replying to.
** $SUBJECT: the subject you're replying to.
*/

/* #define MAILCOMMAND "NONE" */
/* #define MAILCOMMAND "/cgi-bin/mail?to=$TO&replyto=$ID&subject=$SUBJECT"  */
#define MAILCOMMAND "mailto:$TO?subject=$SUBJECT"

/*
** The address of the contact point that is put in the HTML header line 
**   <LINK REV=made HREF=mailto:MAILTO>
**
** The <LINK...> header can be disabled by default by setting MAILTO  to "NONE"
** This can be set in the list config file.
*/

/* #define MAILTO "webmaster@some.domain" */
#define MAILTO "NONE"

/*
** Domain-ize Addresses -- addresses appearing in the RFC822 field 
** which lack hostname can't be made into proper HREFs.  Because the 
** MTA resides on the same host as the list, it is often not required
** to domain-ize these addresses for delivery.  In such cases, hypermail
** will add the DOMAINADDR to the email address.
*/

/* #define DOMAINADDR "some.domain" */
#define DOMAINADDR "NONE"

/*
** Define as the path to an HTML template file that will be used as the
** header of the Index pages. Define as "NONE" to use builtin Index page 
** header by default.
*/
#define IHTMLHEADERFILE "NONE"

/*
** Define as the path to an HTML template file that will be used as the
** footer of the Index pages. Define as "NONE" to use builtin Index page 
** footer by default.
*/
#define IHTMLFOOTERFILE "NONE"

/*
** Define as the path to an HTML template file that will be used as the
** header of the Message pages. Define as "NONE" to use builtin Index page 
** header by default.
*/
#define MHTMLHEADERFILE "NONE"

/*
** Define as the path to an HTML template file that will be used as the
** footer of the Message pages. Define as "NONE" to use builtin Index page 
** footer by default.
*/
#define MHTMLFOOTERFILE "NONE"

/*
** This is the <BODY> line to use when generating the HTML pages.
** Make sure and escape embedded quotes.  Define as "NONE" to use 
** the builtin <BODY> line by default.
*/
#define BODY "<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\">"

/*
** This is the email address used to send a new message to a hypermail
** archive.  "NONE" means don't use it.  Since this is different for each
** hypermail archive, you should probably leave it set to "NONE" here, 
** and let it be specified at runtime by command-line parameters in the 
** list specific configfile.
*/
#define HMAIL "NONE"

/****************************
** MIME Processing Defines **
****************************/

/*
** Define to specify which image mime types should be inlined for
** display in the message. <IMG SRC=..> used for these type instead 
** of <A HREF=...> which forces the user to click on the link.
** Normally limited to images but...
*/
#define INLINE_TYPES "image/gif image/jpeg"

/*
** This is the list of MIME attachment types that you do not want to
** do anything with. They are quietly ignored.  They can be listed 
** as comma or space separated on a single line.
*/

#define IGNORE_TYPES "text/x-vcard application/x-msdownload"

/* End of user-definable options */
#endif /* ACCONFIG_H */
