/*
 * setvesablank.c - aeb - 941230
 *
 * usage: setvesablank ON|on|off
 */
#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>

#include <lct/local.h>
#include <lct/utils.h>
#include <lct/console.h>

char* progname;

void usage()
{
  fprintf(stderr, "Usage: %s ON|on|off\n", progname);
}

void main(int argc, char *argv[]) 
{
  int fd;
  struct { char ten, onoff; } arg;
  
  progname = strip_path(argv[0]);
  
  if (argc != 2) 
      badusage ("wrong number of args");
  
  if (-1 == (fd = get_console_fd(NULL))) exit (1);
  
  arg.ten = 10;
  arg.onoff = 0;
  if (!strcmp(argv[1], "on"))
      arg.onoff = 1;
  else if (!strcmp(argv[1], "ON"))
      arg.onoff = 2;
  if (ioctl(fd, TIOCLINUX, &arg)) 
    {
      fprintf(stderr, "%s: ", progname);
      perror("TIOCLINUX");
      exit(1);
    }
  exit(0);
}
