#ifndef WORKMAN_STUBS_H
#define WORKMAN_STUBS_H
/*
 * $Id: workman_stubs.h,v 1.1 1997/12/19 04:44:14 dirk Exp $
 *
 * This file is part of WorkMan, the civilized CD player program
 * (c) 1991-1997 by Steven Grimm (original author)
 * (c) by Dirk Frsterling (current 'author' = maintainer)
 * The maintainer can be contacted by his e-mail address:
 * milliByte@DeathsDoor.com 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Prototypes for workman_stubs.c
 * 
 * This is just one more step to a more modular and understandable code.
 */

#include <xview/xview.h>
#include <xview/panel.h>
#include "workman_ui.h"

void    send_signal( char *cmd, char *pidfile );
int	update_everything( window1_objects *ip );
void	set_abtimer( int which, int frame );
int	get_playnew( void );
void	figure_volume( window1_objects *ip );
void	next_playmode_default( Panel_item item, int value, Event *event );
Notify_value	handle_timer( Notify_client c, int w );
void	insert_into_playlist( Menu menu, Menu_item item );
int	switch_playlists( Panel_item item, char *string,
                  	  Xv_opaque client_data,
			  Panel_list_op op, Event *event, int row );
void	change_track( Panel_item item, int value, Event *event );
void	change_pos( Panel_item item, int value, Event *event );
void	set_volume( Panel_item item, int value, Event *event );
void	change_mode( Panel_item item, int value, Event *event );
void    next_stopmode( Panel_item item, int value, Event *event );
void    window1_button3_notify_callback( Panel_item item, Event *event );
void    window1_button4_notify_callback( Panel_item item, Event *event );
void    show_cdinfo( Panel_item item, Event *event );
void	goodies_playnewcds_notify_callback( Panel_item item, int value,
					    Event *event );
void	slide_balance( Panel_item item, int value, Event *event );
void	goodies_abrepeat_notify_callback( Panel_item item, int value,
					  Event *event );
void	section_start( Panel_item item, Event *event );
void	section_end( Panel_item item, Event *event );
void	split_track( Panel_item item, Event *event );
void	delete_track(Panel_item item, Event *event );
void	index_scan( Panel_item item, Event *event );
void	plpopup_button7_notify_callback( Panel_item item, Event *event );
void	rename_playlist( Panel_item item, Event *event );
void	delete_playlist( Panel_item item, Event *event );
int	playlist_notify( Panel_item item, char *string,
                 	 Xv_opaque client_data, Panel_list_op op,
			 Event *event, int row );
                                  
#endif /* WORKMAN_STUBS_H */
