/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 *  Routines for control of GF1 chip (synthesizer control things)
 */

#include "driver.h"

struct gf1_ctrl_private_data {
  gus_card_t *card;
};

static int gus_open_control_card( gus_card_t *card, struct gf1_ctrl_private_data *p )
{
  return 0;
}

static void gus_close_control_card( gus_card_t *card, struct gf1_ctrl_private_data *p )
{
  if ( !card ) return;
}
 
int gus_open_control( unsigned short minor, struct file *file )
{
  struct gf1_ctrl_private_data *p;
  int res;

  minor >>= 4;
  minor &= 7;
  if ( minor >= gus_cards_count ) return -ENODEV;
  file -> private_data = gus_malloc( sizeof( struct gf1_ctrl_private_data ) );
  if ( !file -> private_data ) return -ENOMEM;
  p = (struct gf1_ctrl_private_data *)file -> private_data;
  p -> card = gus_cards[ minor ];
  if ( ( res = gus_open_control_card( p -> card, p ) ) < 0 )
    {
      gus_free( p, sizeof( struct gf1_ctrl_private_data ) );
      return res;
    }
  MOD_INC_USE_COUNT;
  return 0;
}

void gus_release_control( struct file *file )
{
  struct gf1_ctrl_private_data *p;
  
  p = (struct gf1_ctrl_private_data *)file -> private_data;
  gus_close_control_card( p -> card, p );
  gus_free( file -> private_data, sizeof( struct gf1_ctrl_private_data ) );
  MOD_DEC_USE_COUNT;
}

int gus_ioctl_control( struct file *file, unsigned int cmd, unsigned long arg )
{  
  struct gf1_ctrl_private_data *p;
  gus_card_t *card;

#if 0
  printk( "ioctl ctl = 0x%x\n", cmd );
#endif
  if ( ( cmd & 0xff00 ) != ( 'g' << 8 ) ) return -EINVAL;
  p = (struct gf1_ctrl_private_data *)file -> private_data;
  card = p -> card;
  switch ( cmd ) {
    case GUS_IOCTL_CTL_CARDS:
      return IOCTL_OUT( arg, gus_cards_count );
    case GUS_IOCTL_CTL_VERSION:
      return IOCTL_OUT( arg, GUS_SYNTH_CTL_VERSION );
    case GUS_IOCTL_CTL_INFO:
      return gus_info( card, NULL, (struct GUS_STRU_INFO *)arg );
    case GUS_IOCTL_CTL_PCM_INFO:
      return gus_pcm_info_flags( NULL, (struct GUS_PCM_INFO *)arg, 1 );
    default:
      PRINTK( "gus: unknown gus_ioctl_control command 0x%x\n", cmd );
  }
  return -EIO;
}

int gus_read_control( struct file *file, char *buf, int count )
{
  return -EIO;
}

int gus_write_control( struct file *file, char *buf, int count )
{
  return -EIO;
}
