/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 */

%{

#include <string.h>
#include "insgus.h"
#include "insgus_parser.h"

#define YY_NO_UNPUT
#undef YY_CDECL
#define YY_CDECL int YY_PROTO(yylex( void ));

int line_count;

%}

%%

	/* special characters */

"{"|"}"			return yytext[0];

	/* keywords */

static_dma		return L_STATIC_DMA;
card			return L_CARD;
id			return L_ID;
order			return L_ORDER;

port			return L_PORT;
irq			return L_IRQ;
ess_irq			return L_ESS_IRQ;
dma1			return L_DMA1;
dma1_size		return L_DMA1_SIZE;
dma2			return L_DMA2;
dma2_size		return L_DMA2_SIZE;

daughter_port		return L_DB_PORT;
daughter_irq		return L_DB_IRQ;
daughter_dma		return L_DB_DMA;
daughter_dma_size	return L_DB_DMA_SIZE;

joystick_dac		return L_JOYSTICK_DAC;

driver			return L_DRIVER;

	/* boolean */

false|off|no		return L_FALSE;
true|on|yes		return L_TRUE;

	/* integers */

[0-9]+			{ yylval.i_value = atoi( yytext ); return L_INTEGER; }
0x[0-9a-f]+		{ char *end;
                          yylval.i_value = strtol( yytext, &end, 0 );
                          return L_INTEGER; }
auto			{ yylval.i_value = 0x100; return L_INTEGER; }
disable			{ yylval.i_value = 0xffff; return L_INTEGER; }

	/* strings */

\"[^\"]*\"              { yytext[ strlen( yytext ) - 1 ] = 0;
                          yylval.s_value = strdup( &yytext[ 1 ] );
                          return L_STRING; }
\'[^\']*\'              { yytext[ strlen( yytext ) - 1 ] = 0;
                          yylval.s_value = strdup( &yytext[ 1 ] );
                          return L_STRING; }
[a-z0-9/\~@-_\+=:,\.]+  { yylval.s_value = strdup( yytext );
                          return L_STRING; }
$[a-z0-9/\~@-_\+=:,\.]+ { yylval.s_value = strdup( getenv( &yytext[ 1 ] ) );
                          return L_STRING; }

	/* comments & whitespaces */

[#\;\!][^\n]*\n		line_count++;
[ \t]+			;
\n			line_count++;
.			fprintf( stderr, "insgus: discarding char '%c' - line %i\n", yytext[0], line_count + 1 );

%%

#ifndef yywrap
int yywrap(void)	/* do this avoid to do -lfl */
{
  return 1;
}
#endif
