// numberlabel.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "numberlabel.h"

static const char *toString(int num) {
	static char tmp[64];
	sprintf(tmp, "%d", num);
	return tmp;
}

static const char *floatFormat(double num) {
	static char format[6];
	double frac = num - int(num);	// take fractional part
	sprintf(format, (frac < 0.0001 && frac != 0.0) ? "%%f" : "%%g");
	return format;
}

static const char *toString(double num) {
	static char tmp[128];
	sprintf(tmp, floatFormat(num), num);
	return tmp;
}

NumberLabel::NumberLabel(int number, int pad)
	: Message(toString(number), Center, pad) {
	init();
}

NumberLabel::NumberLabel(const char *name, int number, int pad)
	: Message(name, toString(number), Center, pad) {
	init();
}

NumberLabel::NumberLabel(double number, int pad)
	: Message(toString(number), Center, pad) {
	init();
}

NumberLabel::NumberLabel(const char *name, double number, int pad)
	: Message(name, toString(number), Center, pad) {
	init();
}

void
NumberLabel::init() {
	SetClassName("NumberLabel");
}
