//
//  Mixer.app
// 
//  Copyright (c) 1998 Per Liden
// 
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
//  USA.
//

#include "Xpm.h"


Xpm::Xpm(char** xpmdata)
{
    int tmp;

    // Create pixmap   
    Attributes.valuemask = 0;
    tmp = XpmCreatePixmapFromData(Dpy, Root, xpmdata,
                                  &Image, &Mask, &Attributes);

    // Check for error
    switch(tmp)
    {
    case XpmColorError:
        cerr << APPNAME << ": xpm image loaded but did not get all colors needed" << endl;
        break;

    case XpmColorFailed:
        cerr << APPNAME << ": could not load xpm image (not enough colors available)" << endl;
        exit(0);
        break;

    case XpmNoMemory:
        cerr << APPNAME << ": could not load xpm image (not enough memory available)" << endl;
        exit(0);
        break;

    case XpmOpenFailed:
    case XpmFileInvalid:
        cerr << APPNAME << ": could not load xpm image (image broken or corrupt)" << endl;
        exit(0);
        break;

    case XpmSuccess:
    default:
        // Image loaded ok
        break;
    }
}


Xpm::~Xpm()
{
    // Free resources
    if(Image)
	XFreePixmap(Dpy, Image);

    if(Mask)
	XFreePixmap(Dpy, Mask);
}


void Xpm::SetWindowPixmap(Window win)
{
    // Set backgroung image
    XResizeWindow(Dpy, win, Attributes.width, Attributes.height);
    XSetWindowBackgroundPixmap(Dpy, win, Image);
}


void Xpm::SetWindowPixmapShaped(Window win)
{
    // Set backgroung image
    XResizeWindow(Dpy, win, Attributes.width, Attributes.height);
    XSetWindowBackgroundPixmap(Dpy, win, Image);
    XShapeCombineMask(Dpy, win, ShapeBounding, 0, 0, Mask, ShapeSet);
}

