/*==============================================================================

  $Id: player.h,v 1.13 1998/09/20 21:45:28 miod Exp $

  Module player example of MikMod

==============================================================================*/

/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
 
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef PLAYER_H
#define PLAYER_H

/*========== Messages */

#define mikversion "-= MikMod'Unix 3.0.4 =-\n"

#define mikbanner mikversion "\n" \
" - Original code by Jean-Paul Mikkers (MikMak) <mikmak@via.nl>\n" \
" - With additions (.IT support) by Jake Stine <dracoirs@epix.net>\n" \
" - FreeBSD support by Douglas Carmichael <dcarmich@mcs.com>\n" \
" - Linux driver by Chris Conn <cconn@tohs.abacom.com>\n" \
" - AudioFile driver by Roine Gustafsson <e93_rog@e.kth.se>\n" \
" - SGI driver by Stephan Kanthak <kanthak@informatik.rwth-aachen.de>\n" \
" - HP-UX and AIX drivers by Lutz Vieweg <lkv@mania.robin.de>\n" \
" - Sun/Solaris driver by Valtteri Vuorikoski <vuori@sci.fi>\n" \
" - curses interface, zip code by Steve McIntyre <stevem@chiark.greenend.org.uk>\n" \
" - playlist, improvements by Peter Amstutz <tetron@segfault.org>\n" \
" - compressed IT sample decoding by Arne de Bruijn <arne@knoware.nl>\n" \
" - bugfixes and current maintenance by Miodrag Vallat <miodrag@mygale.org>\n" \
" - This program is free software covered by the GNU General Public License\n" \
"\nType 'mikmod -h' for command line options!\n" 

#define pausebanner \
"'||''|.    |   '||'  '|' .|'''.| '||''''| '||''|.\n"   \
" ||   ||  |||   ||    |  ||..  '  ||  .    ||   || \n" \
" ||...|' |  ||  ||    |   ''|||.  ||''|    ||    ||\n" \
" ||     .''''|. ||    | .     '|| ||       ||    ||\n" \
".||.   .|.  .||. '|..'  |'....|' .||.....|.||...|'\n"

#define extractbanner \
"'||''''|          .                         .   ||\n"                \
" ||  .   ... ....||. ... ..  ....    .... .||. ... .. ...   ... .\n" \
" ||''|    '|..'  ||   ||' '''' .|| .|   '' ||   ||  ||  || || ||\n"  \
" ||        .|.   ||   ||    .|' || ||      ||   ||  ||  ||  |''\n"   \
".||.....|.|  ||. '|.'.||.   '|..'|' '|...' '|.'.||..||. ||.'||||.\n" \
"                                                          .|....'\n"
#define loadbanner \
"'||'                          '||   ||\n"                  \
" ||         ...    ....     .. ||  ...  .. ...    ... .\n" \
" ||       .|  '|. '' .||  .'  '||   ||   ||  ||  || ||\n"  \
" ||       ||   || .|' ||  |.   ||   ||   ||  ||   |''\n"   \
".||.....|  '|..|' '|..'|' '|..'||. .||. .||. || .'||||.\n" \
"                                                .|....'\n"

#ifdef VIRTCH2
#define keycolontext ""
#else
#define keycolontext ":             toggle interpolation\n"
#endif

#define keyhelptext1 \
"\nKeys help (1/2)\n"                                             \
"===============\n"                                               \
"\n"                                                              \
"(depending on your terminal and your curses library,\n"          \
"some of these keys might not be recognized)\n"                   \
"\n"                                                              \
"H             toggle help panels\n"                              \
"F1..F10       volume\n"                                          \
"Left          previous pattern\n"                                \
"Right         next pattern\n"                                    \
"Up/Down       scroll sample list\n"                              \
"PgUp/PgDown   scroll sample list (faster)\n"                     \
"Home          go to top of sample list\n"                        \
"End           go te end of sample list\n"                        \
"I             toggle samples/instrument lists (if available)\n"  \
"M             toggle sample list/song message (if available)\n"  \

#define keyhelptext2 \
"\nKeys help (2/2)\n"                                             \
"===============\n"                                               \
"\n"                                                              \
"(depending on your terminal and your curses library,\n"          \
"some of these keys might not be recognized)\n"                   \
"\n"                                                              \
"H             toggle help panels\n"                              \
"()            increase/decrease tempo\n"                         \
"{}            increase/decrease bpm\n"                           \
keycolontext                                                      \
"Q             exits MikMod\n"                                    \
"P             switch to previous module in playlist\n"           \
"N             switch to next module in playlist\n"               \
"W             writes the playlist in the current directory\n"    \
"Space         toggle pause\n"                                    \
"^L            refresh screen\n\0"


/*========== Archives */

typedef struct {
  unsigned int location;
  char  *marker;
  char  *command;
  char  *listcmd;
  unsigned int nameoffset;
 } ARCHIVE;

/*========== Playlist */

typedef struct {
	int current;
	int numused;
	CHAR **file;
	CHAR **archive;
} PLAYLIST;

extern PLAYLIST playlist;

extern void PL_ClearList(PLAYLIST*);
extern void PL_InitList(PLAYLIST*);
extern int PL_GetCurrent(PLAYLIST*,CHAR*,CHAR*);
extern int PL_GetNext(PLAYLIST*,CHAR*,CHAR*);
extern int PL_GetPrev(PLAYLIST*,CHAR*,CHAR*);
extern void PL_Randomize(PLAYLIST*);
extern int PL_DelCurrent(PLAYLIST*);
extern void PL_Add(PLAYLIST*,CHAR*,CHAR*);
extern BOOL PL_Load(PLAYLIST*,CHAR*);
extern BOOL PL_Save(PLAYLIST*,CHAR*);

extern CHAR *MA_dearchive(CHAR*,CHAR*);
extern void MA_FindFiles(PLAYLIST*,CHAR*);

/*========== Curses */

extern int firstinst,dispsamp;
extern int winy;
extern int curses_on;

extern void init_display(void);
extern void display_version(void);
extern void display_driver(void);
extern void display_file(void);
extern void display_name(void);
extern void display_information(void);
extern void display_status(void);
extern void display_all(void);
extern void display_extractbanner(void);
extern void display_loadbanner(void);
extern void display_pausebanner(void);
extern void exit_display(void);

#endif
