/*==============================================================================

  $Id: ptform.h,v 1.14 1998/09/20 21:45:14 miod Exp $

  The Protracker enums

==============================================================================*/

/*
	This library is free software; you can redistribute it and/or modify
	it under the terms of the GNU Library General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Library General Public License for more details.
 
	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _PTFORM_H_
#define _PTFORM_H_

#include <tdefs.h>

#ifdef __cplusplus
extern "C" {
#endif

extern UWORD mytab[12],logtab[104];
extern UBYTE VibratoTable[32],avibtab[128];
extern SBYTE PanbrelloTable[256];
extern ULONG lintab[768];

/*========== Internal module representation (UniMod) interface */

/* The UniTrack stuff is generally for internal use only, but would be required
   in making a tracker or a module player tha scrolls pattern data. */

extern void   UniSetRow(UBYTE*);
extern UBYTE  UniGetByte(void);
extern UBYTE *UniFindRow(UBYTE*,UWORD);
extern void   UniReset(void);
extern void   UniWrite(UBYTE);
extern void   UniNewline(void);
extern UBYTE *UniDup(void);
extern void   UniSkipOpcode(UBYTE);
extern BOOL   UniInit(void);
extern void   UniCleanup(void);
extern void   UniInstrument(UBYTE);
extern void   UniNote(UBYTE);
extern void   UniPTEffect(UBYTE,UBYTE);
extern void   UniVolEffect(UWORD,UBYTE);

/*========== Module Commands */

enum {
	/* Simple note */
	UNI_NOTE = 1,
	/* Instrument change */
	UNI_INSTRUMENT,
	/* Protracker effects */
	UNI_PTEFFECT0,
	UNI_PTEFFECT1,
	UNI_PTEFFECT2,
	UNI_PTEFFECT3,
	UNI_PTEFFECT4,
	UNI_PTEFFECT5,
	UNI_PTEFFECT6,
	UNI_PTEFFECT7,
	UNI_PTEFFECT8,
	UNI_PTEFFECT9,
	UNI_PTEFFECTA,
	UNI_PTEFFECTB,
	UNI_PTEFFECTC,
	UNI_PTEFFECTD,
	UNI_PTEFFECTE,
	UNI_PTEFFECTF,
	/* Scream Tracker effects */
	UNI_S3MEFFECTA,
	UNI_S3MEFFECTD,
	UNI_S3MEFFECTE,
	UNI_S3MEFFECTF,
	UNI_S3MEFFECTI,
	UNI_S3MEFFECTQ,
	UNI_S3MEFFECTR,
	UNI_S3MEFFECTT,
	UNI_S3MEFFECTU, 
	UNI_KEYOFF,
	UNI_KEYFADE,
	UNI_VOLEFFECTS,
	/* Fast Tracker effects */
	UNI_XMEFFECT4,
	UNI_XMEFFECTA,
	UNI_XMEFFECTE1,
	UNI_XMEFFECTE2,
	UNI_XMEFFECTEA,
	UNI_XMEFFECTEB,
	UNI_XMEFFECTG,
	UNI_XMEFFECTH,
	UNI_XMEFFECTL,
	UNI_XMEFFECTP,
	UNI_XMEFFECTX1,
	UNI_XMEFFECTX2,
	/* Impulse Tracker effects */
	UNI_ITEFFECTG,     /* Porta to Note .. no kick=0; */
	UNI_ITEFFECTH,     /* IT specific Vibrato */
	UNI_ITEFFECTI,     /* IT tremor (xy not incremeneted) */
	UNI_ITEFFECTM,     /* Set Channel Volume */
	UNI_ITEFFECTN,     /* Slide / Fineslide Channel Volume */
	UNI_ITEFFECTP,     /* Slide / Fineslide Channel Panning */
	UNI_ITEFFECTU,     /* IT fine vibrato */
	UNI_ITEFFECTW,     /* Slide / Fineslide Global volume */
	UNI_ITEFFECTY,     /* The Satanic Panbrello */
	UNI_ITEFFECTS0,

	UNI_LAST
};

/* IT / S3M Extended SS effects: */
enum {
	SS_GLISSANDO = 1,
	SS_FINETUNE,
	SS_VIBWAVE,
	SS_TREMWAVE,
	SS_PANWAVE,
	SS_FRAMEDELAY,
	SS_S7EFFECTS,
	SS_PANNING,
	SS_SURROUND,
	SS_HIOFFSET,
	SS_PATLOOP,
	SS_NOTECUT,
	SS_NOTEDELAY,
	SS_PATDELAY
};

/* IT Volume column effects */
enum {
	VOL_VOLUME = 1,
	VOL_PANNING,
	VOL_VOLSLIDE,
	VOL_PITCHSLIDEDN,
	VOL_PITCHSLIDEUP,
	VOL_PORTAMENTO,
	VOL_VIBRATO
};

/*========== Instruments */

/* Instrument format flags */
#define IF_OWNPAN       1
#define IF_PITCHPAN     2

/* Envelope flags: */
#define EF_ON           1
#define EF_SUSTAIN      2
#define EF_LOOP         4
#define EF_VOLENV       8

/* New Note Action Flags */
#define NNA_CUT         0
#define NNA_CONTINUE    1
#define NNA_OFF         2
#define NNA_FADE        3

#define DCT_OFF         0
#define DCT_NOTE        1                         
#define DCT_SAMPLE      2                         
#define DCT_INST        3           

#define DCA_CUT         0
#define DCA_OFF         1
#define DCA_FADE        2

#define KEY_KICK        0
#define KEY_OFF         1
#define KEY_FADE        2
#define KEY_KILL        3

#define AV_IT           1   /* IT vs. XM vibrato info */

typedef struct ENVPT {
	SWORD pos;
	SWORD val;
} ENVPT;

typedef struct INSTRUMENT {
	UBYTE flags;

	UBYTE samplenumber[120];
	UBYTE samplenote[120];

	UBYTE nnatype;
	UBYTE dca;              /* duplicate check action */
	UBYTE dct;              /* duplicate check type */
	UBYTE globvol;
	UWORD panning;          /* instrument-based panning var */

	UBYTE pitpansep;        /* pitch pan separation (0 to 255) */
	UBYTE pitpancenter;     /* pitch pan center (0 to 119) */
	UBYTE rvolvar;          /* random volume varations (0 - 100%) */
	UBYTE rpanvar;          /* random panning varations (0 - 100%) */

	UWORD volfade;

	UBYTE volflg;           /* bit 0: on 1: sustain 2: loop */
	UBYTE volpts;
	UBYTE volsusbeg;
	UBYTE volsusend;
	UBYTE volbeg;
	UBYTE volend;
	ENVPT volenv[32];

	UBYTE panflg;           /* bit 0: on 1: sustain 2: loop */
	UBYTE panpts;
	UBYTE pansusbeg;
	UBYTE pansusend;
	UBYTE panbeg;
	UBYTE panend;
	ENVPT panenv[32];

	UBYTE pitflg;           /* bit 0: on 1: sustain 2: loop */
	UBYTE pitpts;
	UBYTE pitsusbeg;
	UBYTE pitsusend;
	UBYTE pitbeg;
	UBYTE pitend;
	ENVPT pitenv[32];

/*	UBYTE vibtype; */
/*	UBYTE vibsweep; */
/*	UBYTE vibdepth; */
/*	UBYTE vibrate; */

	CHAR  *insname;
} INSTRUMENT;

/*========== Playing */

typedef struct ENVPR {
	UBYTE flg;          /* envelope flag */
	UBYTE pts;          /* number of envelope points */
	UBYTE susbeg;       /* envelope sustain index begin */
	UBYTE susend;       /* envelope sustain index end */
	UBYTE beg;          /* envelope loop begin */
	UBYTE end;          /* envelope loop end */
	SWORD p;            /* current envelope counter */
	UWORD a;            /* envelope index a */
	UWORD b;            /* envelope index b */
	ENVPT *env;         /* envelope points */
} ENVPR;

/* Used by NNA only player (audio control.  AUDTMP is used for full effects
   control). */
typedef struct MP_VOICE {
	INSTRUMENT  *i;
	SAMPLE      *s;
	UBYTE  sample;       /* which instrument number */

	SWORD  volume;       /* output volume (vol + sampcol + instvol) */
	UWORD  panning;      /* panning position */
	SBYTE  chanvol;      /* channel's "global" volume */
	UWORD  fadevol;      /* fading volume rate */
	UWORD  period;       /* period to play the sample at */

	UBYTE  volflg;       /* volume envelope settings */
	UBYTE  panflg;       /* panning envelope settings */
	UBYTE  pitflg;       /* pitch envelope settings */

	UBYTE  keyoff;        /* if true = fade out and stuff */
	UBYTE  kick;         /* if true = sample has to be restarted */
	UBYTE  note;         /* the audible note (as heard, direct rep of period) */
	UBYTE  nna;          /* New note action type + master/slave flags */
	SWORD  handle;       /* which sample-handle */
	SLONG  start;        /* The start byte index in the sample */

/* Below here is info NOT in MP_CONTROL!! */
	ENVPR  venv;
	ENVPR  penv;
	ENVPR  cenv;

	UWORD  avibpos;      /* autovibrato pos */
	UWORD  aswppos;      /* autovibrato sweep pos */

	ULONG  totalvol;     /* total volume of channel (before global mixings) */

	BOOL   mflag;
	SWORD  masterchn;
	struct MP_CONTROL *master;/* index of "master" effects channel */
} MP_VOICE;

typedef struct MP_CONTROL {
	INSTRUMENT*i;
	SAMPLE *s;
	UBYTE  sample;       /* which sample number */
	UBYTE  note;         /* the audible note as heard, direct rep of period */
	SWORD  outvolume;    /* output volume (vol + sampcol + instvol) */
	SBYTE  chanvol;      /* channel's "global" volume */
	UWORD  fadevol;      /* fading volume rate */
	UWORD  panning;      /* panning position */
	UBYTE  kick;         /* if true = sample has to be restarted */
	UBYTE  muted;        /* if set, channel not played */
	UWORD  period;       /* period to play the sample at */
	UBYTE  nna;          /* New note action type + master/slave flags */

	UBYTE  volflg;       /* volume envelope settings */
	UBYTE  panflg;       /* panning envelope settings */
	UBYTE  pitflg;       /* pitch envelope settings */

	UBYTE  keyoff;       /* if true = fade out and stuff */
	SWORD  handle;       /* which sample-handle */
	UBYTE  notedelay;    /* (used for note delay) */
	SLONG  start;        /* The starting byte index in the sample */

	struct MP_VOICE *slave; /* Audio Slave of current effects control channel */
	UBYTE slavechn;      /* Audio Slave of current effects control channel */
	UBYTE anote;         /* the note that indexes the audible */
	SWORD ownper;
	SWORD ownvol;
	UBYTE dca;           /* duplicate check action */
	UBYTE dct;           /* duplicate check type */
	UBYTE *row;          /* row currently playing on this channel */
	SBYTE retrig;        /* retrig value (0 means don't retrig) */
	ULONG speed;         /* what finetune to use */
	SWORD volume;        /* amiga volume (0 t/m 64) to play the sample at */

	SBYTE tmpvolume;     /* tmp volume */
	UWORD tmpperiod;     /* tmp period */
	UWORD wantedperiod;  /* period to slide to (with effect 3 or 5) */
	UBYTE pansspd;       /* panslide speed */
	UWORD slidespeed;    /* */
	UWORD portspeed;     /* noteslide speed (toneportamento) */

	UBYTE s3mtremor;     /* s3m tremor (effect I) counter */
	UBYTE s3mtronof;     /* s3m tremor ontime/offtime */
	UBYTE s3mvolslide;   /* last used volslide */
	UBYTE s3mrtgspeed;   /* last used retrig speed */
	UBYTE s3mrtgslide;   /* last used retrig slide */

	UBYTE glissando;     /* glissando (0 means off) */
	UBYTE wavecontrol;

	SBYTE vibpos;        /* current vibrato position */
	UBYTE vibspd;        /* "" speed */
	UBYTE vibdepth;      /* "" depth */

	SBYTE trmpos;        /* current tremolo position */
	UBYTE trmspd;        /* "" speed */
	UBYTE trmdepth;      /* "" depth */

	UBYTE fslideupspd;
	UBYTE fslidednspd;
	UBYTE fportupspd;    /* fx E1 (extra fine portamento up) data */
	UBYTE fportdnspd;    /* fx E2 (extra fine portamento dn) data */
	UBYTE ffportupspd;   /* fx X1 (extra fine portamento up) data */
	UBYTE ffportdnspd;   /* fx X2 (extra fine portamento dn) data */

	ULONG hioffset;      /* last used high order of sample offset */
	UWORD soffset;       /* last used low order of sample-offset (effect 9) */

	UBYTE sseffect;      /* last used Sxx effect */
	UBYTE ssdata;        /* last used Sxx data info */
	UBYTE chanvolslide;  /* last used channel volume slide */

	UBYTE panbwave;      /* current panbrello waveform */
	UBYTE panbpos;       /* current panbrello position */
	SBYTE panbspd;       /* "" speed */
	UBYTE panbdepth;     /* "" depth */

	UWORD newsamp;       /* set to 1 upon a sample / inst change */
	UBYTE voleffect;     /* Volume Column Effect Memory as used by IT */
	UBYTE voldata;       /* Volume Column Data Memory */
} MP_CONTROL;


/*======== Module */

/* Various flags */
#define UF_XMPERIODS    1  /* XM periods / finetuning */
#define UF_LINEAR       2  /* LINEAR periods (UF_XMPERIODS must be set) */
#define UF_INST         4  /* Instruments are used */
#define UF_NNA          8  /* New Note Actions used (set numvoices rather than
                              numchn) */

typedef struct UNIMOD {
	UWORD       flags;       /* See UniMod Flags above */
	UBYTE       numchn;      /* number of module channels */
	UBYTE       numvoices;   /* max # voices used for full NNA playback */
	UWORD       numpos;      /* number of positions in this song */
	UWORD       numpat;      /* number of patterns in this song */
	UWORD       numtrk;      /* number of tracks */
	UWORD       numins;      /* number of instruments */
	UWORD       numsmp;      /* number of samples */
	UWORD       reppos;      /* restart position */
	UBYTE       initspeed;   /* initial song speed */
	UBYTE       inittempo;   /* initial song tempo */
	UBYTE       initvolume;  /* initial global volume (0 - 128) */
	UWORD       panning[64]; /* 64 panning positions */
	UBYTE       chanvol[64]; /* 64 channel positions */
	CHAR       *songname;    /* name of the song */
	CHAR       *composer;    /* name of the composer */
	CHAR       *comment;     /* module comments */
	UBYTE     **tracks;      /* array of numtrk pointers to tracks */
	UWORD      *patterns;    /* array of Patterns */
	UWORD      *pattrows;    /* array of number of rows for each pattern */
	UWORD      *positions;   /* all positions */
	INSTRUMENT *instruments; /* all instruments */
	SAMPLE     *samples;     /* all samples */

	/* following are the player-instance variables.  They are in no way file
	   storage related - they are for internal replay use only. */
	CHAR       *modtype;     /* string type of module loaded */
	UBYTE       bpm;         /* current beats-per-minute speed */
	UWORD       sngspd;      /* current song speed */
	SWORD       volume;      /* song volume (0-128) (or user volume) */
	BOOL        extspd;      /* extended speed flag (default enabled) */
	BOOL        panflag;     /* panning flag (default enabled) */
	BOOL        wrap;        /* wrap module ? (default disabled) */
	BOOL        loop;		 /* allow module to loop ? (default enabled) */
	BOOL        fadeout;	 /* volume fade out during last pattern */
	BOOL        forbid;      /* if true, no player update! */

	/* The following variables are considered useful for reading, and should
	   not be directly modified by the end user. */
	MP_CONTROL *control;     /* Effects Channel information (size pf->numchn) */
	MP_VOICE   *voice;       /* Audio Voice information (size md_numchn) */
	UWORD       numrow;      /* number of rows on current pattern */
	UWORD       vbtick;      /* tick counter (counts from 0 to sngspd) */
	UWORD       patpos;      /* current row number */
	SWORD       sngpos;      /* current song position */
	ULONG       sngtime;     /* current song time in 2^-10 seconds */
	UWORD       sngremainder;/* used for song time computation */

	/* The following variables should not be modified, and have information that	   is pretty useless outside the internal player. */
	UBYTE       globalslide; /* global volume slide rate */
	SWORD       pat_reppos;  /* patternloop position */
	UWORD       pat_repcnt;  /* times to loop */
	UWORD       pat_cnt;     /* time spent in this pattern */
	UBYTE       pat_repcrazy;/* module has just looped to position -1 */
	UWORD       patbrk;      /* position where to start a new pattern */
	UBYTE       patdly;      /* patterndelay counter (command memory) */
	UBYTE       patdly2;     /* patterndelay counter (real one) */
	SWORD       posjmp;      /* flag to indicate a position jump is needed... */
} UNIMOD;

/*========== Loaders */

typedef struct MLOADER {
	struct MLOADER *next;
	CHAR    *type;
	CHAR    *version;
	BOOL    (*Init)(void);
	BOOL    (*Test)(void);
	BOOL    (*Load)(void);
	void    (*Cleanup)(void);
	CHAR    *(*LoadTitle)(void);
} MLOADER;

/* public loader variables: */
extern FILE   *modfp;
extern UWORD  finetune[16];
extern UNIMOD of;           /* static unimod loading space */
extern UWORD  npertab[60];  /* used by the original MOD loaders */

/*========== Loaders interface */

extern CHAR*   ML_InfoLoader(void);
extern void    ML_RegisterLoader(MLOADER*);
extern UNIMOD *MikMod_LoadSongFP(FILE*,int);
extern UNIMOD *MikMod_LoadSong(CHAR*,int);
extern void    MikMod_FreeSong(UNIMOD*);

/*========== Internal loader interface */

extern BOOL  InitTracks(void);
extern void  AddTrack(UBYTE*);
extern BOOL  ReadComment(UWORD);
extern BOOL  ReadLinedComment(UWORD,UWORD);
extern BOOL  AllocPositions(int);
extern BOOL  AllocPatterns(void);
extern BOOL  AllocTracks(void);
extern BOOL  AllocInstruments(void);
extern BOOL  AllocSamples(void);
extern CHAR *DupStr(CHAR*,UWORD);

/*========== Known loaders */

extern MLOADER load_mod; /* Standard 31-instrument Module loader */
extern MLOADER load_m15; /* 15-instrument */
extern MLOADER load_mtm; /* Multi-Tracker Module (by Renaissance) */
extern MLOADER load_s3m; /* ScreamTracker 3 (by Future Crew) */
extern MLOADER load_stm; /* ScreamTracker 2 (by Future Crew) */
extern MLOADER load_ult; /* UltraTracker  */
extern MLOADER load_xm;  /* FastTracker 2 (by Triton) */
extern MLOADER load_it;  /* Impulse Tracker (by Jeffrey Lim) */
extern MLOADER load_669; /* 669 and Extended-669 (by Tran / Renaissance) */
extern MLOADER load_dsm; /* DSIK internal module format */
extern MLOADER load_med; /* MMD0 and MMD1 Amiga MED modules (by OctaMED) */
extern MLOADER load_far; /* Farandole Composer Module */

/* used to convert c4spd to linear XM periods (IT loader). */
extern UWORD getlinearperiod(UBYTE,ULONG);
extern ULONG getfrequency(UBYTE,ULONG);

/*========== Player interface */

/* This batch of functions affects the currently ACTIVE module set with
   MikMod_PlayStart) */
extern void   Player_Start(UNIMOD*);
extern BOOL   Player_Active(void);
extern void   Player_Stop(void);
extern void   Player_TogglePause(void);
extern BOOL   Player_Paused(void);
extern void   Player_NextPosition(void);
extern void   Player_PrevPosition(void);
extern void   Player_SetPosition(UWORD);
extern BOOL   Player_Muted(UBYTE);
extern void   Player_HandleTick(void);
extern void   Player_SetVolume(SWORD);
extern UNIMOD *Player_GetUnimod(void);
extern void   Player_SetSpeed(UWORD);
extern void   Player_SetTempo(UWORD);

extern BOOL   Player_Init(UNIMOD*); /* internal use only [by loader] */
extern void   Player_Exit(UNIMOD*); /* internal use only [by loader] */

#ifdef __cplusplus
}
#endif
#endif

