/*
 *  ISA DMA support functions
 *  Copyright (c) by Jaroslav Kysela <perex@jcu.cz>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "driver.h"

/*
 * DMA isn't disabled now when residue is read. Looks that this causes
 * problems with some DMA controllers. Maybe old controllers may give
 * wrong values, so if you have this problem - try change bellow line.
 */

#undef SND_DISABLE_DMA_WHEN_RESIDUE

#if defined( LINUX_2_1 ) && defined( __SMP__ ) && LinuxVersionCode( 2, 1, 95 ) > LINUX_VERSION_CODE
#error "Use kernel 2.1.95+... Previous kernels have bug caused by spinlocks..."
#endif

void snd_dma_program( int dma, const void *buf, unsigned int size, unsigned char mode )
{
  unsigned long flags;
  
  /* we don't have a DMA spinlock... */
  snd_cli( &flags );
  disable_dma( dma );
  clear_dma_ff( dma );
  set_dma_mode( dma, mode );
  set_dma_addr( dma, virt_to_bus( (void *)buf ) );
  set_dma_count( dma, size );
  enable_dma( dma );
  snd_sti( &flags );
}

unsigned int snd_dma_residue( int dma )
{
  unsigned long flags;
  unsigned int result;
  
  /* we don't have a DMA spinlock... */
  snd_cli( &flags );
#ifdef SND_DISABLE_DMA_WHEN_RESIDUE
  disable_dma( dma );
#endif
  clear_dma_ff( dma );
  result = get_dma_residue( dma );
#ifdef SND_DISABLE_DMA_WHEN_RESIDUE
  enable_dma( dma );
#endif
  snd_sti( &flags );
  return result;
}
