"""
  PDA.Palm.Conduit.Backup - Conduit which maintains a backup of the Palm
  $Id: Backup.py,v 1.8 1998/09/13 05:12:12 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


  This conduit maintains a backup of the PalmOS device, one of the
  most basic operations a conduit can perform.
"""

import PDA.Palm
import PDA.Palm.Conduit

import os, string, stat, sys

from PDA.Palm import Options, protect_name

backup_dir = None

class Conduit(PDA.Palm.Conduit.Conduit):
    def __init__(self):
	PDA.Palm.Conduit.Conduit.__init__(self)

	self.name = 'Backup'
	self.version = '0.1'
	self.author = 'Rob Tillotson <rob@io.com>'
	self.url = ''
	self.description = 'Backs up the PalmOS device.'

	# options and configuration
	#self.options = ['backup_dir', 'ignore_backup_bit', 'incremental']
	self.define_options([
#	    Options.Filename('backup_dir', None, 'Backup Directory'),
	    Options.Boolean('ignore_backup_bit', 1, 'Ignore Backup Bit?'),
	    Options.Boolean('incremental', 1, 'Incremental?')
	    ])

    def __call__(self, dlp, username):
	path = os.path.join(self.registry.user_directory(username), 'backup')
	
	self.log('user: "%s"  path: "%s"' % (username, path))
	try:
	    os.stat(path)
	except os.error:
	    os.mkdir(path)

	dblist = os.listdir(path)  # for use in incremental backup
	
	i = 0
	while 1:
	    info = dlp.getDBInfo(i, 1, 0, 0)
	    if not info: break
	    i = info['index'] + 1

	    if self.ignore_backup_bit or info['flagBackup']:
		if info['flagResource']: fn = info['name'] + '.prc'
		else: fn = info['name'] + '.pdb'
		fn = protect_name(fn)
		fp = os.path.join(path, fn)
		
		info['flagOpen'] = 0

		doit = 0
		if not self.incremental or fn not in dblist:
		    doit = 1
		else:
		    fi = PDA.Palm.openFile(fp, None).info
		    if fi['modifyDate'] != info['modifyDate'] or \
		       fi['modnum'] != info['modnum']:
			doit = 1
			
		if doit:
		    self.log('backing up "%s"' % info['name'])
		    f = PDA.Palm.createFile(fp, info, None)
		    try:
			f.retrieve(dlp)
		    except:
			self.log('failed to back up "%s"' % info['name'])
		    f.close()
		    
	    if fn in dblist: dblist.remove(fn)
	    
	if self.incremental:
	    for fn in dblist:
		self.log('removing "%s" from backup directory' % fn)
		os.unlink(os.path.join(path, fn))
		
	self.log('done.')

