/* $Id: dbz-v3.h,v 1.2 1998/07/12 09:39:19 src Exp $
 *
 * for dbm and dbz
 *
 * $Log: dbz-v3.h,v $
 * Revision 1.2  1998/07/12 09:39:19  src
 * NewsX version 1.0
 *
 */
typedef struct {
	char *dptr;
	int dsize;
} datum;

/* standard dbm functions */
extern int dbminit();
extern datum fetch();
extern int store();
extern int delete();            /* not in dbz */
extern datum firstkey();        /* not in dbz */
extern datum nextkey();         /* not in dbz */
extern int dbmclose();          /* in dbz, but not in old dbm */

/* new stuff for dbz */
extern int dbzdbminit();
extern datum dbzdbmfetch();
extern int dbzdbmstore();
extern int dbzdbmclose();
extern int dbzfresh();
extern int dbzagain();
extern datum dbzfetch();
extern int dbzstore();
extern int dbzsync();
extern long dbzsize();
extern long dbztagmask();
extern int dbzincore();
extern int dbzwritethrough();
extern void (*dbzfiledesc())();
extern int dbzcancel();
extern int dbzdebug();

/*
 * In principle we could handle unlimited-length keys by operating a chunk
 * at a time, but it's not worth it in practice.  Setting a nice large
 * bound on them simplifies the code and doesn't hurt anything.
 */
#define DBZMAXKEY       255
