.\" @(#)mknbi-dos.8
.\"
.\" Copyright (C) 1996-1998 Gero Kuhlmann   <gero@gkminix.han.de>
.\"
.\"  This program is free software; you can redistribute it and/or modify
.\"  it under the terms of the GNU General Public License as published by
.\"  the Free Software Foundation; either version 2 of the License, or
.\"  any later version.
.\"
.\"  This program is distributed in the hope that it will be useful,
.\"  but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"  GNU General Public License for more details.
.\"
.\"  You should have received a copy of the GNU General Public License
.\"  along with this program; if not, write to the Free Software
.\"  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.TH MKNBI-DOS 8 "11 May 1997"
.SH NAME
mknbi\-dos \- MaKe NetBoot Image for DOS

.SH SYNOPSIS
.LP
.B mknbi\-dos
[OPTIONS] [<ramdisk> [<output file>]]

.SH DESCRIPTION
.B mknbi\-dos
is a program to convert a
.SM MS\-DOS
or
.SM OpenDOS
boot disk image into a file suitable for loading by diskless
systems using a
.SM Boot\-Rom.

.SH OPTIONS
.TP
.B \-b, \-\-batch-sys SYS
Lets
.B mknbi\-dos
operate in batch mode. It will look up the given system name in a
database file and generate a netbootable image according to the
parameters given in the database entry. If this option is not
given,
.B mknbi\-dos
will operate according to the other command line options. If giving
any other options in addition to
.B \-b
or
.BR \-\-batch-sys ,
the parameters found in the database will override those processed from
the command line.
.TP
.B \-c, \-\-simulate-hard-disk
Let the ram disk get mounted as a virtual hard disk instead of a
floppy drive. Only floppy drives can be removed lateron, but a
hard disk image can have a user selectable size.
.TP
.B \-C, \-\-config-file FILE
Specifies a configuration file.
.TP
.B \-f, \-\-skip-check
Disable certain validity checks when creating the ramdisk image. Normally
.SM mknbi\-dos
checks whether a ramdisk image has been created using a DOS system which
is compatible with MS\-DOS version 5.0 or higher or OpenDOS (though these
checks are by no means complete). If you want to boot another DOS-compatible
system like DR-DOS and
.SM mknbi\-dos
complains about an invalid ramdisk image,
try using this option. But note that the DOS you want to boot has to
support the RPL functionality of interrupt 2Fh. FreeDOS, the free DOS
clone, for example, does
.B not
work with
.SM mknbi\-dos
for this reason.
.TP
.B \-h, \-\-help
Print short usage information.
.TP
.B \-n, \-\-no-hard-disk
When the ramdisk is simulating a floppy disk drive, this switch will
disable hard disk accesses. This is necessary if the client should
use a network file system as drive C:, which is only possible if there
are no hard disks found by DOS.
.TP
.B \-N, \-\-netboot-dir DIR
Specifies the path of the main netboot directory.
.TP
.B \-o, \-\-outfile FILE
Pathname of output file, which is lateron loaded by the
.SM Boot-Rom
via
.SM tftp.
.TP
.B \-r, \-\-ramdisk-image DIR|FILE
Pathname of ramdisk image. This can either be a file, a floppy
device or a directory. If it's a directory,
.SM mknbi\-dos
will treat all files in that directory as MS\-DOS files and will create
a ramdisk image with a DOS filesystem and a simple boot sector
in it. The directory has to contain at least the files
.SM IO.SYS,
.SM MSDOS.SYS
and
.SM COMMAND.COM.
Alternatively, it can also contain the corresponding files for IBM\-DOS
or OpenDOS.
.TP
.B \-s, \-\-ramdisk-size SIZE
Size of ramdisk in kB, which can not be smaller than that of the
ramdisk image. If this option is missing, the size is determined
from the size of the ramdisk image, if that image is a file. If it's
a directory and this
option is missing, the ramdisk size defaults to 1.44 MB. This option
can be used with or without the
.B \-c
option. However, when it is used without
.B \-c
then the specified ramdisk size has to be one of 320, 360, 720, 1200,
1440 or 2880. Otherwise, any arbitrary ramdisk size can be selected.
.TP
.B \-v, \-\-version
Print version information.
.TP
.B \-x, \-\-verbose
Increase verbosity level.

.SH RAMDISK SIZE
The actual size of the ramdisk is determined by several parameters. When
the ramdisk is going to simulate a floppy drive, only the standard floppy
sizes are available:
.BR 320 ,
.BR 360 ,
.BR 720 ,
.BR 1200 ,
.B 1440
or
.B 2880
kB. If the
.B \-s
or
.B \-\-ramdisk-size
options are not used, the actual ramdisk size will be identical to that
of the floppy used for generating the ramdisk image, or 1440 kB if a UNIX
directory is used. However, if the
.B \-s
or
.B \-\-ramdisk-size
switches are used, the value given has to exactly match the size of the
source floppy image, or it can specify any value out of the standard floppy
sizes as mentioned above when using a UNIX directory.
.P
When the ramdisk is going to simulate a hard drive by using the
.B \-c
or
.B \-\-simulate-hard-disk
switch, the ramdisk size is determined by the size of the source floppy,
or 1440 kB when using a UNIX directory as source. If using the
.B \-s
or
.B \-\-ramdisk-size
options the ramdisk size will be determined by the option argument, no
matter what size the source floppy or UNIX directory has. The argument
to the
.B \-s
or
.B \-\-ramdisk-size
option can have any value larger than 360 and is not restricted to the
standard floppy values mentioned above. The maximum value is 16000.
.P
When using a UNIX directory as the ramdisk image source, it's contents
has to fit into the size as determined above. If the contents is larger,
an error will be produced. However, due to internal restrictions the
maximum amount of actual data on the source image or in the UNIX directory
is limited to around 8 MB. This means that even though the ramdisk can
have a maximum size of about 16 MB it can only be preset with data of
about half this size.

.SH MEMORY MANAGEMENT
The bootrom loads the image file created by
.B mknbi\-dos
so that the ramdisk image is placed at the start of the extended memory
on the client. When DOS starts, this memory area is not protected in any
way against clobbering by client programs. But if the ramdisk driver finds
that a XMS driver like
.SM HIMEM.SYS
gets loaded, it will use it to allocate a XMS memory block to protect the
ramdisk. Unfortunately,
.SM HIMEM.SYS,
starting with version 3.10, does a check of extended memory which destroys
the ramdisk image. You can use either a version of
.SM HIMEM.SYS
prior to 3.10, or use the command line option /TESTMEM:OFF.
When booting OpenDOS you have to load
.SM HIMEM.SYS
before starting
.SM EMM386.EXE
even though the documentation and the screen messages say that the
.SM HIMEM.SYS
functionality is incorporated within
.SM EMM386.EXE.
Unfortunately, when loading
.SM EMM386.EXE
alone the ramdisk image gets corrupted for some reason. This can only be
prevented when explicitely using
.SM HIMEM.SYS
with OpenDOS.
.P
To remove a ramdisk you can use the program
.B rmrd.com
which not only restores access to the physical drive which has been
replaced by the ramdisk, but also frees all memory (including extended
memory) used by the ramdisk image. However, a ramdisk can only be
removed, if it is simulating a floppy disk drive (see option
.B \-c
above). In a standard installation
.B rmrd.com
can be found in the directory /usr/lib/netboot/utils.

.SH DATABASE FILE
.B mknbi\-dos
does not use any sections in the configuration file except the [general]
section. However, for easier maintenance of different client configurations
the database file can be used. The entries have to be preceded by a
[<system name>:mknbi-dos] tag and can contain the following parameters:
.TP
.B outfile
Specifies the name of the output file
.TP
.B ramdisk-image
Specifies the name of the ramdisk image file or directory
.TP
.B ramdisk-size
Specifies the size of the ramdisk. This parameter works like the
.B \-s
or
.B \-\-ramdisk-size
command line arguments. The ramdisk size gets therefore determined in
the same way as described above.
.TP
.B skip-check
This boolean parameter specifies wether to skip certain compatibility
checks.
.TP
.B no-hard-disk
Boolean parameter which specifies if to allow hard disk accesses in the
client or not.
.TP
.B simulate-hd
This boolean parameter allows the ramdisk to simulate a hard disk in the
client.

.SH BUGS
None known yet.

.SH SEE ALSO
netboot.config(5)

.SH AUTHOR
.B mknbi-dos
was written by
.SM Gero Kuhlmann <gero@gkminix.han.de>.

