
/***

ifstats.h - structure definitions for interface counts
	
***/

struct iflist {
    char ifname[8];
    unsigned long long iptotal;
    unsigned long badtotal;
    unsigned long long noniptotal;
    unsigned long long total;
    unsigned int spanbr;
    unsigned long br;
    float rate;
    float peakrate;
    unsigned int index;
    struct iflist *prev_entry;
    struct iflist *next_entry;
};

struct iftab {
    struct iflist *head;
    struct iflist *tail;
    struct iflist *firstvisible;
    struct iflist *lastvisible;
    WINDOW *borderwin;
    PANEL *borderpanel;
    WINDOW *statwin;
    PANEL *statpanel;
};

struct ifstat_brackets {
    unsigned int floor;
    unsigned int ceil;
    unsigned long count;
};

struct iftotals {
    unsigned long long total;
    unsigned long long bytestotal;
    unsigned long long iptotal;
    unsigned long long ipbtotal;
    unsigned long long noniptotal;
    unsigned long long nonipbtotal;
    unsigned long long tcptotal;
    unsigned long long tcpbtotal;
    unsigned long long udptotal;
    unsigned long long udpbtotal;
    unsigned long long icmptotal;
    unsigned long long icmpbtotal;
    unsigned long long othtotal;
    unsigned long long othbtotal;
    unsigned long badtotal;

    unsigned int interval;
    struct ifstat_brackets brackets[16];
};
