/*
   Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#ifndef s_TextentryP_h
#define s_TextentryP_h

#include "Textentry.h"
/* include superclass private header file */
#include <X11/CoreP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

#define XtRTextentryResource "TextentryResource"

typedef struct {
    int empty;
} TextentryClassPart;

typedef struct s_TextentryClassRec {
    CoreClassPart	core_class;
    TextentryClassPart	textentry_class;
} TextentryClassRec;

extern TextentryClassRec textentryClassRec;

typedef struct {
    /* resources */
	Cursor cursor;
	int insert_pos;
	Boolean display_caret;
	char *string;
	Pixel foreground;
	XFontStruct *font;
	int top;
    /* private state */
	GC clear_gc;
	GC draw_gc;
	GC cursor_gc;
	char *text;
	int sel_top, sel_bot;
} TextentryPart;

typedef struct s_TextentryRec {
    CorePart		core;
    TextentryPart	textentry;
} TextentryRec;

#endif /* s_TextentryP_h */
