/*
   Copyright (C) 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

/* 
 * Egon.c - Egon composite widget
 */

#include	<X11/IntrinsicP.h>
#include	<X11/StringDefs.h>
#include	<X11/Xmu/Misc.h>
#include	<X11/Xaw/Command.h>
#include	"EgonP.h"

/****************************************************************
 *
 * Egon Resources
 *
 ****************************************************************/

/* These are bogus; they are hand-me-downs from Box */

static XtResource resources[] = {
    { XtNhSpace, XtCHSpace, XtRDimension, sizeof(Dimension),
		XtOffsetOf(EgonRec, egon.h_space),
		XtRImmediate, (XtPointer)4 },
    { XtNvSpace, XtCVSpace, XtRDimension, sizeof(Dimension),
		XtOffsetOf(EgonRec, egon.v_space),
		XtRImmediate, (XtPointer)4 }
};

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

#if 0
static void Initialize();
#endif
static void Resize();
static Boolean SetValues();
static XtGeometryResult GeometryManager();
static void ChangeManaged();

EgonClassRec egonClassRec = {
  {
/* core_class fields      */
    /* superclass         */    (WidgetClass) &compositeClassRec,
    /* class_name         */    "Egon",
    /* widget_size        */    sizeof(EgonRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */	NULL,
    /* class_inited       */	FALSE,
    /* initialize         */    NULL,
    /* initialize_hook    */	NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions	  */	0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    Resize,
    /* expose             */    NULL,
    /* set_values         */    SetValues,
    /* set_values_hook    */	NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */	NULL,
    /* accept_focus       */    NULL,
    /* version            */	XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */	XtInheritQueryGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension          */	NULL
  },{
/* composite_class fields */
    /* geometry_manager   */    GeometryManager,
    /* change_managed     */    ChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension          */	NULL
  },{
/* Egon class fields */
    /* empty		  */	0
  }
};

WidgetClass egonWidgetClass = (WidgetClass)&egonClassRec;


/****************************************************************
 *
 * Private Routines
 *
 ****************************************************************/

/*
 * Do a layout, actually assigning positions.
 */

static void DoLayout(EgonWidget sw)
{
	Widget propv, tickv, objv;
	Dimension w1, w2, w3, h1;

	w3 = sw->core.width;
	h1 = sw->core.height;
	w1 = w3/3;
	if (w1 > 100) {
		w1 = (w3-100)/2;
		w2 = w1+100;
	} else {
		w2 = 2*w1;
	}
	if (w1 < 2) w1 = 2;
	if (w2 < w1+2) w2 = w1+2;
	if (w3 < w2+2) w3 = w2+2;

	switch (sw->composite.num_children) {
	case 3:
		propv = sw->composite.children[2];
		XtConfigureWidget(propv, w2, 0, w3-w2, h1, 1);
	case 2:
		tickv = sw->composite.children[1];
		XtConfigureWidget(tickv, w1, 0, w2-w1, h1, 1);
	case 1:
		objv = sw->composite.children[0];
		XtConfigureWidget(objv, 0, 0, w1, h1, 1);
	default:
		;
	}
}

/*
 * Actually layout egon
 */

static void Resize(Widget w)
{
	DoLayout((EgonWidget)w);
} /* Resize */

/*
 * Geometry Manager
 *
 * 'reply' is unused; we say only yeay or nay, never almost.
 */

static XtGeometryResult GeometryManager(Widget w,
		XtWidgetGeometry request, XtWidgetGeometry reply)
{
	return XtGeometryYes;
}

static void ChangeManaged(Widget w)
{
    DoLayout((EgonWidget)w);
}

#if 0	/* testing compound widget code */
static Widget selectall;

static void Initialize(Widget request, Widget new,
		ArgList args, Cardinal *num_args)
{
	selectall = XtVaCreateManagedWidget("selectall",
		commandWidgetClass, new, (char *)0);
} /* Initialize */

Widget gross_hack(void)
{
	return selectall;
}
#endif

#if 0	/* not used yet */
static void Realize(Widget w, Mask *valueMask, XSetWindowAttributes *attributes)
{
	;
} /* Realize */
#endif

static Boolean SetValues(Widget current, Widget request, Widget new,
		ArgList args, Cardinal *num_args)
{
    return False;
}
