"summary.mcmc" <-
function (x, quantiles = c(0.025, 0.25, 0.5, 0.75, 0.975), combine.chains = F, 
        ...) 
{
        chain.names <- chanames(x)
        mcpar <- c(start = start(x), end = end(x), thin = thin(x))
        combine.chains <- combine.chains && (nchain(x) > 1)
        if (combine.chains) 
                Nchains.stats <- 1
        else Nchains.stats <- nchain(x)
        statnames <- c("Mean", "SD", "Naive SE", "Time-series SE")
        chain.names <- if (combine.chains) 
                NULL
        else chanames(x)
        varstats <- array(dim = c(nvar(x), 4, Nchains.stats), 
                dimnames = list(varnames(x), statnames, chain.names))
        for (j in 1:Nchains.stats) {
                if (combine.chains) {
                        xmean <- apply(x, 2, mean, na.rm = T)
                        xvar <- apply(x, 2, var, na.rm = T)
                        xvar <- diag(var(matrix(aperm(x, c(2, 
                                1, 3)), ncol = nvar(x), byrow = T)))
                        xnse <- apply(x, 2, geweke.nse)
                        n.used <- niter(x) * nchain(x)
                }
                else {
                        xmean <- apply(x[, , j], 2, mean, na.rm = T)
                        xvar <- apply(x[, , j], 2, var, na.rm = T)
                        xnse <- apply(x[, , j], 2, geweke.nse)
                        n.used <- niter(x)
                }
                varstats[, 1, j] <- xmean
                varstats[, 2, j] <- sqrt(xvar)
                varstats[, 3, j] <- sqrt(xvar/n.used)
                varstats[, 4, j] <- xnse
        }
        varstats <- drop(varstats)
        varquant <- if (combine.chains) 
                t(apply(x, 2, quantile, quantiles))
        else aperm(apply(x, c(2, 3), quantile, quantiles), c(2, 
                1, 3))
        varquant <- drop(varquant)
        out <- list(statistics = varstats, quantiles = varquant, 
                mcpar = mcpar, combined = combine.chains, chain.names = chanames(x))
        class(out) <- "summary.mcmc"
        return(out)
}
