"plot.mcmc" <-
function (x, trace = T, density = T, combine.chains = F, smooth = T, 
        bwf, auto.layout = T, one.page = F, ...) 
{
        oldpar <- NULL
        if (auto.layout) {
                mfrow <- set.mfrow(Nchains = nchain(x), Nparms = nvar(x), 
                        nplots = trace + density, sepplot = !combine.chains, 
                        one.page = one.page)
                oldpar <- par(mfrow = mfrow)
        }
        oldpar <- c(oldpar, par(set.scale()))
        on.exit(par(oldpar))
        if (combine.chains) {
                for (i in 1:nvar(x)) {
                        if (trace) 
                                traceplot(x[, i, , drop = F], 
                                 combine.chains = T, smooth = smooth)
                        if (density) 
                                if (missing(bwf)) 
                                 densplot(x[, i, , drop = F], 
                                  combine.chains = T)
                                else densplot(x[, i, , drop = F], 
                                 combine.chains = T, bwf = bwf)
                        if (i != nvar(x) && mpause2()) 
                                break
                }
        }
        else for (j in 1:nchain(x)) {
                for (i in 1:nvar(x)) {
                        if (trace) 
                                traceplot(x[, i, j], combine.chains = F, 
                                 smooth = smooth)
                        if (density) 
                                if (missing(bwf)) 
                                 densplot(x[, i, j, drop = F], 
                                  combine.chains = F)
                                else densplot(x[, i, j, drop = F], 
                                 combine.chains = F, bwf = bwf)
                        if (!(i == nvar(x) && j == nchain(x)) && 
                                mpause2()) {
                                stop.plot <- TRUE
                                break
                        }
                }
                if (exists("stop.plot", inherits = F) && stop.plot) 
                        break
        }
}
