"join.mcmc" <-
function (...) 
{
        x <- list(...)
        if (length(x) == 1 && is.list(x[[1]])) 
                x <- x[[1]]
        if (!all(unlist(lapply(x, is.mcmc)))) 
                stop("Arguments must be mcmc objects")
        nargs <- length(x)
        if (nargs == 1) 
                return(x[[1]])
        xtspar <- lapply(x, tspar)
        xtspar1 <- xtspar[[1]]
        if (!all(unlist(lapply(xtspar, "==", xtspar1)))) 
                stop("Arguments have different tspar attributes")
        xdim <- matrix(unlist(lapply(x, dim)), nrow = 3)
        if (any(xdim[1, ] != xdim[1, 1])) 
                stop("Chains have different numbers of iterations")
        if (any(xdim[2, ] != xdim[2, 1])) 
                stop("Chains have different numbers of variables")
        end.chn <- cumsum(xdim[3, ])
        start.chn <- c(1, end.chn[-nargs] + 1)
        n.chn <- sum(xdim[3, ])
        y <- array(NA, dim = c(xdim[1:2, 1], n.chn))
        ydn <- list(NULL, NULL, character(n.chn))
        for (i in 1:nargs) {
                y[, , start.chn[i]:end.chn[i]] <- x[[i]]
                xdn <- dimnames(x[[i]])
                if (!is.null(xdn)) {
                        if (!is.null(xdn[[1]])) 
                                if (is.null(ydn[[1]])) 
                                 ydn[[1]] <- xdn[[1]]
                                else if (any(ydn[[1]] != xdn[[1]])) 
                                 stop("Unequal variable names")
                        if (!is.null(xdn[[2]])) 
                                if (is.null(ydn[[2]])) 
                                 ydn[[2]] <- xdn[[2]]
                                else if (any(ydn[[2]] != xdn[[2]])) 
                                 stop("Unequal variable names")
                        if (!is.null(xdn[[3]])) 
                                ydn[[3]][start.chn[i]:end.chn[i]] <- xdn[[3]]
                        else ydn[[3]][start.chn[i]:end.chn[i]] <- rep(NA, 
                                dim(x[[i]])[3])
                }
        }
        dimnames(y) <- ydn
        mcmc(y, start = xtspar1[1], end = xtspar1[2], thin = xtspar1[3])
}
