"codamenu.options.geweke.bin" <-
function (next.menu) 
{
        cat("\nOptions for defining bin size to plot Geweke's diagnostic:\n")
        choices <- c("Default: bin width = 10; maximum number of bins = 50", 
                "User-specified bin width", "User-specified total number of bins")
        pick <- menu(choices)
        if (pick == 0) 
                return("quit")
        switch(pick, {
                coda.options(geweke.max = 50)
                coda.options(geweke.bin = 10)
        }, {
                coda.options(geweke.max = 0)
                default <- if (coda.options("geweke.bin") == 
                        0) 
                        10
                else coda.options("geweke.bin")
                msg <- "Enter required bin width:"
                coda.options(geweke.bin = read.and.check(msg, 
                        lower = 1, upper = niter(work.dat) - 
                                50, default = default))
        }, {
                coda.options(geweke.bin = 0)
                default <- if (coda.options("geweke.max") == 
                        0) 
                        50
                else coda.options("geweke.max")
                msg <- "Enter total number of bins required:"
                coda.options(geweke.max = read.and.check(msg, 
                        lower = 1, upper = niter(work.dat) - 
                                50, default = default))
        })
        return(next.menu)
}
