\name{Ops.polynomial}
\title{Group Method for Arithmetic Operators with
Polynomials}
\usage{
Ops.polynomial(e1, e2)
}
\arguments{
\item{e1}{A polynomial}
\item{e2}{A polynomial}
}
\description{
Allows arithmetic operators to be used for polynomial calculations, such
as addition, multiplication, division, etc.

Most operations are as anticipated, however the two operators "/" and
"\%/\%" have identical results.
}
\value{
A polynomial got by performing the operation on the two arguments.
}
\seealso{
Math.polynomial, Summary.polynomial
}
\examples{
print(p <- polynomial(c(1,2,1))) ## 1 + 2*x + x^2 
r <- poly.from.zeros(-1:1)
r
## -1*x + x^3 
pr <- (r - 2 * p)^2
pr
## 4 + 20*x + 33*x^2 + 16*x^3 - 6*x^4 - 4*x^5 + x^6 
}
