% $Id: asOneSidedFormula.Rd,v 1.3 1998/04/02 18:53:09 pinheiro Exp $
\name{asOneSidedFormula}
\title{Convert to One-Sided Formula}
\usage{
asOneSidedFormula(object)
}
\alias{asOneSidedFormula}
\arguments{
 \item{object}{a one-sided formula, an expression, or a character
   string.}
}
\description{
  Names, expressions, and strings are converted to one-sided
  formulas. If \code{object} is a formula, it must be one-sided, in
  which case it is returned unaltered.
}
\value{
  a one-sided formula representing \code{object}
}
\author{Jose Pinheiro and Douglas Bates}

\seealso{\code{\link{formula}}}

\examples{
library(lme)
asOneSidedFormula("age")
asOneSidedFormula(~ age)
}
\keyword{models}
