/*
 * ColormapPoint.c
 * author: Brian T. Luense
 * date: August 18, 1994
 */

#include	<stdio.h>
#include	"ColorMapDefs.h"
#include	"color.h"
#include	"transformn.h"
#include	"BasicFns.h"

/*This file contains the functions which can be used to determine what color to
make a point under a given colormap.*/

void addcomponentcolor(ColorA *color, HPointN *pt, char *coordsys, dir *plex,
	char *obj)
{	TransformN *t;
	int i,j, smdim;
	float hgt, weight;
	HPointN *newpt;
	if(plex->np==1)	/*If there is only one mark color the point that color*/
	{	color->r+=(*(plex->p))->c.r;
		color->g+=(*(plex->p))->c.g;
		color->b+=(*(plex->p))->c.b;
		color->a+=(*(plex->p))->c.a;
		return;
	}
	/*Find smaller of dimensions of the point and the direction*/
	smdim = (pt->dim < plex->dim) ? pt->dim : plex->dim;
      	/*If map is specified with respect to the object make an identify matrix*/
	if (strcmp(coordsys,obj)==0)
	{	t=TmNCreate(pt->dim, pt->dim, NULL);
		for(i=0;i<t->idim;i++)
			for(j=0;j<t->odim;j++)
				if(i==j)
					*(t->a + i*(t->idim) + j) = 1.0;
	}
	/*Otherwise get the appropriate transform*/
	else
	{	printf("(echo (ND-xform-get %s %s))\n",obj,coordsys);
		fflush(stdout);
		t=TmNRead(stdin);
	}
	newpt=HPtNTransform(t,pt,NULL);	/*apply transform*/
	hgt=InnerProductN(newpt->v,plex->direction,smdim);/*get point's height*/
	free(newpt);
	/*Find index of smallest height larger than ours*/
	for(i=0;(i<plex->np)&&(hgt>((plex->p)[i])->height);i++);
	if(i==0)	/*If none smaller use smallest*/
	{	color->r+=(*(plex->p))->c.r;
		color->g+=(*(plex->p))->c.g;
		color->b+=(*(plex->p))->c.b;
		color->a+=(*(plex->p))->c.a;
		return;
	}
	if(i==plex->np)	/*If none larger use largest*/
	{	color->r+=(*(plex->p + i))->c.r;
		color->g+=(*(plex->p + i))->c.g;
		color->b+=(*(plex->p + i))->c.b;
		color->a+=(*(plex->p + i))->c.a;
		return;
	}		/*Otherwise interpolate in between*/
	weight=(hgt-(*(plex->p + i - 1))->height)/
		((*(plex->p + i))->height-(*(plex->p+i-1))->height);
	color->r+=(*(plex->p + i -1))->c.r+weight*((*(plex->p + i))->c.r - 
		(*(plex->p + i - 1))->c.r);
	color->g+=(*(plex->p + i -1))->c.g+weight*((*(plex->p + i))->c.g - 
		(*(plex->p + i - 1))->c.g);
	color->b+=(*(plex->p + i -1))->c.b+weight*((*(plex->p + i))->c.b - 
		(*(plex->p + i - 1))->c.b);
	color->a+=(*(plex->p + i -1))->c.a+weight*((*(plex->p + i))->c.a - 
		(*(plex->p + i - 1))->c.a);
	return;
}

/*Takes a pointer to an HPointN, a pointer to a colormap, and a string identifying
the object to which the point belongs.*/

ColorA *colorpoint(HPointN *pt, colormap *map, char *obj)
{	ColorA *color;
	int i;
	color=(ColorA *)malloc(sizeof *color);	/*Makes space for colors*/
	color->r=color->g=color->b=color->a=0.0;/*Starts off with 0's*/
	for(i=0;i<map->numdirs;i++)		/*Color along each direction*/	
		addcomponentcolor(color,pt,(map->coordsys)[i],
			(map->plex)[i], obj);
	if(color->r < 0.0)		/*if any color is less than 0 or bigger*/
		color->r=0.0;		/*than 1 then make 0 or 1 respectively*/
	if(color->r > 1.0)
		color->r=1.0;
	if(color->g < 0.0)
		color->g=0.0;
	if(color->g > 1.0)
		color->g=1.0;
	if(color->b < 0.0)
		color->b=0.0;
	if(color->b > 1.0)
		color->b=1.0;
	if(color->a < 0.0)
		color->a=0.0;
	if(color->a > 1.0)
		color->a=1.0;
	return color;
}
