/* Copyright (c) 1995 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Author: Timothy Rowley */

#include <stdio.h>
#include <stdlib.h>
#include <tk.h>

#include "geom.h"
#include "color.h"
#include "callbacks.h"
#include "ui.h"
#include "crayola.h"

static Tcl_Interp *magic;
static Color rgb, hsv;

void
uiFreeze(void)
{
}

void
uiThaw(void)
{
}

static int
checkOperation(char *op)
{
    char *value = Tcl_GetVar(magic, "operation", 0);

    if (!strcmp(value, op))
	return 1;
    else
	return 0;
}

int
uiGet(void)
{
    return checkOperation("get");
}

int
uiSet(void)
{
    return checkOperation("set");
}

int
uiSetAll(void)
{
    return checkOperation("setall");
}

int
uiEliminateColor(void)
{
    return checkOperation("eliminate");
}

static char cscl[] = ".crayola.c";

static void
setsliders(char *which, Color *c)
{
    char s[200];
    sprintf(s, "setsliders %s {%g %g %g}", which, c->r, c->g, c->b);
    Tcl_Eval(magic, s);
}

void
uiChangeColor(ColorA *color)
{
    rgb = *(Color *)color;
    rgb2hsv(&rgb, &hsv);
    setsliders("rgb", &rgb);
    setsliders("hsv", &hsv);
    Tcl_Eval(magic, "newColor");
}

void
uiCurrentColor(ColorA *color)
{
    *(Color *)color = rgb;
    color->a = 1.0;
}

int
uiQuery(char *ques1, char *ques2, char *ques3, char *res1, char *res2)
{
    Tcl_VarEval(magic, "tk_dialog .question Query {", ques1, " ", ques2, " ",
		ques3, "} {} -1 \"", res1, "\" \"", res2, "\"", NULL);
    return atoi(magic->result);
}

int
undoCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
    undo();
    return TCL_OK;
}

int
setColorCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
    Color *c = &rgb;

    if(argc > 1 && strcmp(argv[1], "-hsv") == 0) {
	c = &hsv;
	argc--;
	argv++;
    }
	
    if (argc != 4)
    {
	Tcl_SetResult(interp, "usage: crayolaSetColor ?-hsv? r g b", TCL_STATIC);
	return TCL_ERROR;
    }
    c->r = atof(argv[1]);
    c->g = atof(argv[2]);
    c->b = atof(argv[3]);
    if(c == &hsv) {
	hsv2rgb(&hsv, &rgb);
	setsliders("rgb", &rgb);
    } else {
	rgb2hsv(&rgb, &hsv);
	setsliders("hsv", &hsv);
    }
    return TCL_OK;
}

int
quitCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
    quit();
    return TCL_OK;
}

static void
handler(ClientData clientData, int mask)
{
    dopipes();
}

int
crayola_init(Tcl_Interp *interp)
{
    Tk_Window main = Tk_MainWindow(interp);

    magic = interp;
    Tcl_CreateCommand(interp, "crayolaSetColor", setColorCmd, 
		      (ClientData) main, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(interp, "crayolaUndo", undoCmd, (ClientData) main,
		      (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(interp, "crayolaQuit", quitCmd, (ClientData) main,
		      (Tcl_CmdDeleteProc *) NULL);

    init();
    uiThaw();
    Tk_CreateFileHandler(0, TK_READABLE, handler, 0);
    return TCL_OK;
}

