/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:19:40 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-backward 4 */

/*
 * This function contains 36 FP additions, 21 FP multiplications,
 * (or, 28 additions, 13 multiplications, 8 fused multiply/add),
 * 16 stack variables, and 32 memory accesses
 */
static const fftw_real K2_000000000 = FFTW_KONST(+2.000000000000000000000000000000000000000000000);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_backward_4(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (4 * iostride);
     {
	  fftw_real tmp46;
	  fftw_real tmp49;
	  fftw_real tmp44;
	  fftw_real tmp47;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp45;
	       fftw_real tmp48;
	       fftw_real tmp42;
	       fftw_real tmp43;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp45 = X[iostride];
	       tmp46 = K2_000000000 * tmp45;
	       tmp48 = Y[-iostride];
	       tmp49 = K2_000000000 * tmp48;
	       tmp42 = X[0];
	       tmp43 = X[2 * iostride];
	       tmp44 = tmp42 + tmp43;
	       tmp47 = tmp42 - tmp43;
	  }
	  X[2 * iostride] = tmp44 - tmp46;
	  X[0] = tmp44 + tmp46;
	  X[iostride] = tmp47 - tmp49;
	  X[3 * iostride] = tmp47 + tmp49;
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 3) {
	  fftw_real tmp16;
	  fftw_real tmp35;
	  fftw_real tmp25;
	  fftw_real tmp32;
	  fftw_real tmp19;
	  fftw_real tmp31;
	  fftw_real tmp28;
	  fftw_real tmp36;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp14;
	       fftw_real tmp15;
	       fftw_real tmp23;
	       fftw_real tmp24;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp14 = X[0];
	       tmp15 = Y[-2 * iostride];
	       tmp16 = tmp14 + tmp15;
	       tmp35 = tmp14 - tmp15;
	       tmp23 = Y[0];
	       tmp24 = X[2 * iostride];
	       tmp25 = tmp23 - tmp24;
	       tmp32 = tmp23 + tmp24;
	  }
	  {
	       fftw_real tmp17;
	       fftw_real tmp18;
	       fftw_real tmp26;
	       fftw_real tmp27;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp17 = X[iostride];
	       tmp18 = Y[-3 * iostride];
	       tmp19 = tmp17 + tmp18;
	       tmp31 = tmp17 - tmp18;
	       tmp26 = Y[-iostride];
	       tmp27 = X[3 * iostride];
	       tmp28 = tmp26 - tmp27;
	       tmp36 = tmp26 + tmp27;
	  }
	  X[0] = tmp16 + tmp19;
	  {
	       fftw_real tmp21;
	       fftw_real tmp29;
	       fftw_real tmp20;
	       fftw_real tmp22;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp21 = tmp16 - tmp19;
	       tmp29 = tmp25 - tmp28;
	       tmp20 = c_re(W[1]);
	       tmp22 = c_im(W[1]);
	       X[2 * iostride] = (tmp20 * tmp21) + (tmp22 * tmp29);
	       Y[-iostride] = (tmp20 * tmp29) - (tmp22 * tmp21);
	  }
	  Y[-3 * iostride] = tmp25 + tmp28;
	  {
	       fftw_real tmp33;
	       fftw_real tmp37;
	       fftw_real tmp30;
	       fftw_real tmp34;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp33 = tmp31 + tmp32;
	       tmp37 = tmp35 - tmp36;
	       tmp30 = c_re(W[0]);
	       tmp34 = c_im(W[0]);
	       Y[-2 * iostride] = (tmp30 * tmp33) - (tmp34 * tmp37);
	       X[iostride] = (tmp34 * tmp33) + (tmp30 * tmp37);
	  }
	  {
	       fftw_real tmp39;
	       fftw_real tmp41;
	       fftw_real tmp38;
	       fftw_real tmp40;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp39 = tmp32 - tmp31;
	       tmp41 = tmp35 + tmp36;
	       tmp38 = c_re(W[2]);
	       tmp40 = c_im(W[2]);
	       Y[0] = (tmp38 * tmp39) - (tmp40 * tmp41);
	       X[3 * iostride] = (tmp40 * tmp39) + (tmp38 * tmp41);
	  }
     }
     if (i == m) {
	  fftw_real tmp1;
	  fftw_real tmp2;
	  fftw_real tmp4;
	  fftw_real tmp5;
	  fftw_real tmp6;
	  fftw_real tmp7;
	  fftw_real tmp13;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp1 = X[0];
	  tmp2 = X[iostride];
	  tmp4 = tmp1 - tmp2;
	  tmp5 = Y[-iostride];
	  tmp6 = Y[0];
	  tmp7 = tmp5 + tmp6;
	  X[0] = K2_000000000 * (tmp1 + tmp2);
	  tmp13 = c_im(W[1]);
	  X[2 * iostride] = tmp13 * (K2_000000000 * (tmp6 - tmp5));
	  {
	       fftw_real tmp8;
	       fftw_real tmp3;
	       fftw_real tmp9;
	       fftw_real tmp11;
	       fftw_real tmp10;
	       fftw_real tmp12;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp8 = tmp4 - tmp7;
	       tmp3 = c_re(W[0]);
	       tmp9 = c_im(W[0]);
	       X[iostride] = (tmp3 * tmp8) - (tmp9 * tmp8);
	       tmp11 = tmp4 + tmp7;
	       tmp10 = c_re(W[2]);
	       tmp12 = c_im(W[2]);
	       X[3 * iostride] = (tmp10 * tmp11) + (tmp12 * tmp11);
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3};
fftw_codelet_desc fftw_hc2hc_backward_4_desc =
{
     "fftw_hc2hc_backward_4",
     (void (*)()) fftw_hc2hc_backward_4,
     4,
     FFTW_BACKWARD,
     FFTW_HC2HC,
     75,
     3,
     twiddle_order,
};
