/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998, Double Precision Inc.                                    */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	"maildir.h"
#include	"mio.h"
#include	"alarmtimer.h"
#include	"alarmsleep.h"
#include	"autoconf.h"
#include	"config.h"
#include	"funcs.h"
#if HAVE_SYS_STAT_H
#include	<sys/stat.h>
#endif
#include	<errno.h>
#include	"mytime.h"

#if HAVE_UNISTD_H
#include	<unistd.h>
#endif

#if	HAS_GETHOSTNAME
#else
extern "C" int gethostname(const char *, size_t);
#endif

static const char rcsid[]="$Id: maildir.C 1.2 1998/06/21 17:49:09 mrsam Exp $";

Maildir::Maildir() : is_open(0)
{
}

Maildir::~Maildir()
{
	MaildirAbort();
}

////////////////////////////////////////////////////////////////////////////
//
//  Attempt to detect if this is a Maildir directory.
//
////////////////////////////////////////////////////////////////////////////

int Maildir::IsMaildir(const char *name)
{
Buffer	dirname;
Buffer	subdirname;
struct	stat stat_buf;

int	c;

	if (!name || !*name)	return (0);	// Nope, not a Maildir
	dirname=name;
	c=dirname.pop();
	if (c != SLASH_CHAR)	dirname.push(c);	// Strip trailing /
	subdirname=dirname;
	subdirname += "/tmp";
	subdirname += '\0';
	if ( stat( (const char *)subdirname, &stat_buf ) ||
		! S_ISDIR(stat_buf.st_mode) )	return (0);
	subdirname=dirname;
	subdirname += "/new";
	subdirname += '\0';
	if ( stat( (const char *)subdirname, &stat_buf ) ||
		! S_ISDIR(stat_buf.st_mode) )	return (0);
	subdirname=dirname;
	subdirname += "/cur";
	subdirname += '\0';
	if ( stat( (const char *)subdirname, &stat_buf ) ||
		! S_ISDIR(stat_buf.st_mode) )	return (0);
	return (1);	// If it looks like a duck, walks like a duck...
}

int	Maildir::MaildirOpen(const char *dir, Mio &file)
{
char	hostname[256];
struct	stat stat_buf;

	MaildirAbort();

Buffer	dirname, filename;

	dirname=dir;

int	c=dirname.pop();

	if (c != SLASH_CHAR)	dirname.push(c);	// Strip trailing /

	hostname[0]=0;
	hostname[sizeof(hostname)-1]=0;
	gethostname(hostname, sizeof(hostname)-1);

AlarmTimer	abort_timer;

	abort_timer.Set( 24 * 60 * 60 );
	while (!abort_timer.Expired())
	{
	time_t	t;

		filename="";
		time(&t);
		filename.append( (unsigned long)t);
		filename += '.';
		filename.append( (unsigned long)getpid() );
		filename += '.';
		filename += hostname;
		tmpname=dirname;
		tmpname += "/tmp/";
		tmpname += filename;
		tmpname += '\0';
		newname=dirname;
		newname += "/new/";
		newname += filename;
		newname += '\0';

		if (stat( (const char *)tmpname, &stat_buf) < 0 &&
			errno == ENOENT &&
			file.Open( (const char *)tmpname, O_CREAT|O_WRONLY,
					MAILBOX_MODE) >= 0)
		{
			is_open=1;
			return (0);
		}

	AlarmSleep	try_again(2);
	}

	merr << "maildrop: time out on maildir directory.\n";
	return (-1);
}

void	Maildir::MaildirSave()
{
	if (is_open && link( (const char *)tmpname, (const char *)newname) < 0)
		throw "link() failed.\n";
}

void	Maildir::MaildirAbort()
{
	if (is_open)	unlink( (const char *)tmpname );
}
