
static char rcsid[] = "@(#)$Id: posixsig.c,v 1.2 1998/10/20 19:57:48 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Duplicate the old signal() call with POSIX sigaction

**/

#include "headers.h"

#ifdef POSIX_SIGNALS

#ifndef SIG_ERR
#  ifdef BADSIG
#    define SIG_ERR BADSIG
#  else
#    define SIG_ERR -1
#  endif /* BADSIG */
#endif /* SIG_ERRR */

/*
 * This routine used to duplicate the old signal() calls
 */
SIGHAND_TYPE
#if ANSI_C && !defined(apollo)
(*posix_signal(signo, fun))(int)
	int signo;
	SIGHAND_TYPE (*fun)(int);
#else
(*posix_signal(signo, fun))()
	int signo;
	SIGHAND_TYPE (*fun)();
#endif
{
	struct sigaction act;	/* new signal action structure */
	struct sigaction oact;  /* returned signal action structure */ 

	/*   Setup a sigaction struct */

 	act.sa_handler = fun;        /* Handler is function passed */
	sigemptyset(&(act.sa_mask)); /* No signal to mask while in handler */
	act.sa_flags = 0;
#ifdef SA_INTERRUPT
	act.sa_flags |= SA_INTERRUPT;           /* SunOS */
#endif

	/* use the sigaction() system call to set new and get old action */

	sigemptyset(&oact.sa_mask);
	if(sigaction(signo, &act, &oact))
		/* If sigaction failed return -1 */
	    return(SIG_ERR);
	else
        	/* use the previous signal handler as a return value */
	    return(oact.sa_handler);
}
#endif /* POSIX_SIGNALS */

extern int errno;

#ifdef BACKGROUD_PROCESSES       /* We assume POSIX in here */

int my_wait (pid,statptr)
     int pid; 
#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
     union wait *statptr;
#else
     int *statptr;
#endif
{
  int ret,err;
  dprint(10, (debugfile, "my_wait(%d,...) ... with BACKGROUD_PROCESSES\n", 
	      pid));
  errno = 0;
  ret = waitpid(pid,statptr,0);
  err = errno;

#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
  dprint(10, (debugfile, "my_wait(%d,*statptr=%d) = %d\n", pid,
	      statptr->w_status,ret));
#else
  dprint(10, (debugfile, "my_wait(%d,*statptr=%d) = %d\n", pid,
	      *statptr,ret));
#endif

  if (err) {
    dprint(10, (debugfile, " *** errno=%d (%s)\n",err,
		error_description(err)));
  }
  errno = err;
  return ret;
}

#else

int my_wait (pid,statptr)
     int pid; 
#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
     union wait *statptr;
#else
     int *statptr;
#endif
{
  int ret,err;
  dprint(10, (debugfile, "my_wait(%d,...) ... no BACKGROUD_PROCESSES\n", pid));
  errno = 0;
  ret = wait(statptr);
  err = errno;
  dprint(10, (debugfile, "my_wait(%d,*statptr=%d) = %d\n", pid,
#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
	      statptr->w_status
#else
	      *statptr
#endif
	      ,ret));
  if (err) {
    dprint(10, (debugfile, " *** errno=%d (%s)\n",err,
		error_description(err)));
  }
  errno = err;
  return ret;

}
#endif

int convert_status(status,exit_code) 
#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
     union wait status;
#else
     int status;
#endif
     int *exit_code;
{
  int sig;
#ifdef	WEXITSTATUS
  *exit_code = WEXITSTATUS(status);
  if (WIFSIGNALED(status)) {
     sig        = WTERMSIG(status);
     dprint(10, (debugfile, "convert_status: TERMINATED WITH SIGNAL %d\n",
                 sig));
  } else
     sig        = 0;
#else
# ifdef	BSD_TYPE
  *exit_code = status.w_retcode;
  sig        = status.w_termsig;
# else
  *exit_code = status >> 8;
  sig        = status & 128;
# endif
#endif

  dprint(10, (debugfile, "convert_status=%d (sig): exit_code=%d\n", 
	      sig,*exit_code));

  return sig;
}
