/* $Id: me.h,v 1.20.2.3 1999/10/10 15:56:50 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.20.2.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "melib.h"

#define PUBLIC 
/* args.c */

extern char * parse_arguments P_((int, char *[], char ***, int *));

/* init.c */
void initialize P_((char *, int));

/* elm.c */
extern void motion P_((int));
extern void check_range P_(());

/* in_utils.c */

extern int want_to          P_((char *, int, int, int));
extern int read_number      P_((int, char *));
extern int optionally_enter P_((char *, int, int, int, int));
extern int pattern_enter    P_((char *, char *, int, int, char *, int, int));
extern int GetPrompt        P_((void));

/* out_utils.c */

extern void sleep_message P_((void));
extern int  error P_((CONST char *s));
extern void out_util_setup P_((void));
extern void show_last_error P_((void));
extern void clear_error P_((void));
extern void set_error P_((char *s));
extern void lower_prompt P_((char *s));
extern void prompt P_((char *s));
extern void set_central_message P_((char *string, char *arg));
extern void display_central_message P_((void));
extern void clear_central_message P_((void));

/* pattern.c */

extern int from_matches P_((int message_number, char *pat));
extern int to_matches P_((int message_number, char *pat));
extern int cc_matches P_((int message_number, char *pat));
extern int subject_matches P_((int message_number, char *pat));
extern int match_in_message P_((char *pat));

/* addr_util.c */

extern char * kludge_addr P_((char **addr));

struct textual {
  char *textual;
  int pos;
  int len;
};

struct expanded_address {
  struct addr_item *addrs;
  int addrs_len;

  struct textual *surface;
  int surface_len;
};

struct mailing_headers {
  char *subject;
  char *in_reply_to;
  char *expires;
  char *action; 
  char *priority;

  struct expanded_address reply_to; 
  struct expanded_address to;
  struct expanded_address cc;
 
  char *user_defined_header;
  struct expanded_address bcc;
  char *precedence;
  char *expires_days;
};

extern int build_address P_((char *, char *, int, int ));
extern int build_address_l P_((struct expanded_address *expanded));
extern int argv_to_expanded P_((struct expanded_address *result,
				char *argv[]));
extern void addr_to_expanded P_((struct expanded_address *result,
				 struct addr_item *addrs));
extern void expanded_to_edit_buffer P_((char * buffer, int size,  
					struct expanded_address expanded));
extern void update_expanded_from_edit_buffer P_((struct expanded_address 
						 *expanded,
						 CONST char *buffer));
extern void zero_expanded_address P_((struct expanded_address *x));
extern void free_expanded_address P_((struct expanded_address *x));
extern void copy_expanded_address P_((struct expanded_address *result,
				      struct expanded_address source));

extern void write_addr_header P_((FILE *f, char *hdr_name, 
				  struct addr_item * addr,
				  int top_encoding));
extern void write_text_header P_((FILE *f, char *hdr_name, 
				  char * text,
				  int top_encoding));
extern int check_8bit_addr P_((struct addr_item * addr));

extern char **argv_from_headers   P_((struct mailing_headers * headers));
extern void dump_expanded_address P_((int debuglevel, CONST char *text,
				      struct expanded_address expanded));

extern int aliases_to_expanded P_((struct expanded_address *x));

/* Alias.c */

extern void alias P_((void));
extern void main_state P_((void));
extern void open_alias_files P_((int are_in_aliases));

/* a_sort.c */

void sort_aliases P_((int entries, int visible, int are_in_aliases));


/* a_screen.c */

extern void build_alias_line P_((char *buffer,
				 struct alias_rec *entry,
				 int message_number, int highlight,
				 int buffer_size));

extern void alias_screen P_((int modified));
extern void alias_title P_((int modified));
extern void show_alias_menu P_((void));


/* a_quit.c */

extern void exit_alias P_((void));

/* file.c */

int expand_filename P_((char *, int, int));
void init_helpmsg P_(( char *, char *, int, int ));

/* fileutil.c */

/* Open and possible creates file for updates */

extern FILE *open_or_create P_((char *name));
extern FILE *open_end_update P_((char *name));

/* src/remailer.c */

#ifdef USE_REMAILER
extern int remailer_copy_message_across P_((FILE *, FILE *, int, mime_send_t *));
extern int remailer_proc P_((void));
#endif 

#ifdef USE_PGP
/* pgp.c */
extern int pgp_menu			P_((char *filename,
					    struct mailing_headers *headers));
extern int pgp_extract_public_key	P_((void));
#endif

/* read_rc.c */

extern void directory_check     P_((void));



extern int metapager		P_((FILE *, struct header_rec *, int));
extern int builtinplusplus	P_((FILE *, long, int, char **, int));

/* mime.c */

extern int have_metamail        P_((void));

/* strings.c */


extern char **argv_from_to      P_((char *to));
extern void copy_sans_escape P_((
				 unsigned char *dest, char *source,
				 int  len));
extern void split_word P_((
			   char *buffer, char *first, char *rest));
extern void Centerline P_((int line,
			   char *string));


/* string2.c */

void remove_possible_trailing_spaces P_((char *string));

/* fileio.h */
extern void copy_message P_((FILE *, struct header_rec *,
			     char *, FILE *, int));

extern void copy_plain P_((char *,FILE *,int, struct header_rec *, FILE *));
extern void copy_mime P_((char *,FILE *,int, struct header_rec *, FILE *));

typedef void copy_decoder P_((char *,FILE *,int, struct header_rec *, FILE *));
typedef copy_decoder *copy_decoder_t;
extern copy_decoder_t select_copy_decoder P_((struct header_rec *));

/* newmbox.c */

extern struct folder_info {
  char *cur_folder;	  /* name of current folder */
  char cur_tempfolder[SLEN]; /* name of temp folder open for a mailbox */

  int  folder_type;	/* flag: type of folder		      */
  int use_temp;
  FILE *fh_folder;               /* current folder 	    */
  FILE *fh_temp;		/* current folder 	    */
  long mailfile_size;	/* size of current mailfile */
  int  lock_state;
#ifdef	USE_DOTLOCK_LOCKING
  char *lockfile;
#endif  /* USE_DOTLOCK_LOCKING */
  int create_fd;	/* file descriptor for creating lock file */

} * current_folder;

extern void header_zero P_((struct header_rec *));
extern void header_clear P_((struct header_rec *));
extern void close_folder P_((struct folder_info *folder));
extern int open_folder_lock P_((int direction,struct folder_info *folder));
extern int reopen_folder_lock_sessionlock P_((struct folder_info *folder));
extern int is_pre_mime_content_type P_((mime_t *,char *));
extern int same_file P_((char *,char *)); 



/* file_util.c */

extern long fsize P_((FILE *));
extern long bytes P_((char *));
extern int copy_to_folder P_((FILE * from, struct folder_info *to));
extern int copy1 P_((FILE *from, char *to, int isspool));

/* mailmsg1.c */

extern void zero_mailing_headers P_((struct mailing_headers *hdrs));
extern void free_mailing_headers P_((struct mailing_headers *hdrs));

int send_msg_argv P_((char *argv[],
		      char *given_subject,int options, int form));

extern int send_msg_l P_((struct header_rec * current_header,
			  struct addr_item *given_to, 
			  struct addr_item *given_cc,
			  char *given_subject,
			  int   options, int form_letter));
extern void display_to P_((struct expanded_address address));
extern int get_to P_((struct expanded_address *to));

/* mailmsg2.c */

#ifdef ANSI_C
struct run_state;           /* Needed for prototype */
#endif


extern int mail P_((struct header_rec *, int, int, struct mailing_headers *));
extern int mail_form P_((struct header_rec *, struct addr_item *, char *));
extern int mail_backend P_((FILE *real_reply,
			    struct mailing_headers * headers,
			    int dsn,  end_handler *func, 
			    int encoding_top, char *title,
			    int resend));
extern int check_8bit_str P_((char *str));    

/* froms.c */

extern int mail_filled_in_form P_((struct header_rec * current_header,
				   struct addr_item *address,
				   char *subject));


/* aliaslib.c */

extern char *get_alias_address P_((
				   char *name, /* name to expand as an alias */
				   int mailing, /* TRUE to fully expand group names & recursive aliases */
				   int *too_longp /* error code if expansion overflows buffer             */
				   ));


struct addr_item *get_alias_address_l P_((
					  char *name, /* name to expand as an alias */
					  int mailing, /* TRUE to fully expand group names & recursive aliases */
					  int *too_longp /* error code if expansion overflows buffer             */
					  ));


/* syscall.c */

extern int system_call    P_((char *, int));
extern int have_printout  P_((void));
extern int print_msg      P_((int pause_on_scroll));


extern void list_folders P_((unsigned numlines,
			     char *helpmsg,
			     char *wildcard));

/* lib/errno.c */

extern char *error_description P_((int));

/* savecopy.c */

extern int name_copy_file P_((char *, int));

extern int save_copy P_((
			 struct mailing_headers * headers,
			 char *filename, char *copy_file,
			 int form,
			 mime_send_t *mime_info));

extern int append_copy_to_file P_((struct mailing_headers * headers,
				   char *fname_copy,
				   char *fname_mssg,
				   int form,
				   mime_send_t *mime_info));

extern  FILE * write_header_info P_((char *filename,
				     struct mailing_headers * headers,
				     int   form, int copy,
				     mime_send_t *mime_info));

extern void copy_message_across	P_((FILE *, FILE *, int, mime_send_t *));

/* mime.c */

extern int check_for_multipart	P_((FILE *, mime_send_t *));
extern int Include_Part		P_((FILE *, char *, int, mime_send_t *, int));
extern int needs_encoding       P_((FILE *));

/* mime_encode.c */

extern void attach_generate_message P_((mime_t *, FILE *, int, mime_send_t *));
extern void base64_encode	    P_((FILE *, FILE *, int, mime_send_t *));
extern void line_quoted_printable_encode P_((char *, FILE *, int, int,
					       int, mime_send_t *));
extern void quoted_printable_encode	P_((FILE *, FILE *, int, int,
						mime_send_t *));
extern int is_text_type			P_((char *, char *, int));
extern char *mime_generate_boundary	P_((char *, int));
extern void add_parameter		P_((char *,char *,char *,int, int));
extern void add_parameter_t             P_((mime_t *, char *, char *, int));

extern void print_EOLN			P_((FILE *,int));
extern int update_encoding		P_((int *,int));
extern void write_encoded   P_((FILE *, FILE *, int, int, int, mime_send_t *));
extern void mime_write_header		P_((FILE *, mime_send_t *, int));
extern void rfc1522_encode_text         P_((char *,int,CONST char *,int));

/* attach_menu.c */

extern mime_t *attach_menu		P_((mime_t *, int));
extern int Attach_it                    P_((char *));
extern int Check_attachments            P_((void));

/* returnadd.c */
extern void kludge                      P_((char *buffer, int size));

/* lock.c */


/* the following is true if the current mailfile is the user's spool file*/
#define USERS_SPOOL(x) 	x && (strcmp(x->cur_folder, defaultfile) == 0)
#define MAILFILE(x)    (x ? (x -> use_temp ? x->fh_temp : x -> fh_folder) : NULL)


extern int Grab_the_file P_((int flock_fd));
extern int Release_the_file P_((int flock_fd));
extern int unlock P_((int interrupt, struct folder_info *folder));
extern int lock P_((int direction,struct folder_info *folder));
extern int flush_mailfile P_((struct folder_info *folder));


/* utils.c */

extern void emergency_exit P_((int interrupt));
extern void leave P_((int interrupt));
extern void create_new_folders P_((void));
extern void create_new_elmdir P_((void));
extern void rm_temps_exit P_((void));
extern void silently_exit P_((void));
extern void leave_locked P_((int));




/* date.c */

extern void days_ahead P_((int days, char *buffer, int size));
extern char * elm_date_str P_((char *buf, time_t seconds, int size));
extern void make_menu_date P_((struct header_rec *entry));

/* expires.h */

extern void process_expiration_date P_((char *date,
					int  *message_status));


/* reply.c */

extern int get_return_name P_((
			       char *address, char *name,
			       int   trans_to_lowercase,
			       int size));

/* leavembox.c */

int leave_mbox P_((
		   int resyncing,  int quitting, int prompt));
		
/* mkhdrs.c */

extern void generate_reply_to P_((struct header_rec * current_header,
				  struct mailing_headers *headers));

extern void add_mailheaders P_((FILE *filedesc));

/* hdrconfig.c */

extern void edit_headers P_((struct mailing_headers *headers));
extern char *hdr_to_expval P_((struct expanded_address addrs));
extern void hdr_to_buffer P_((struct expanded_address addrs, 
			      char **ptr, int *size));
extern int buffer_to_header P_((struct expanded_address *addrs,char *ptr,
				int free_only));

/* remail.c */

extern int remail P_((void));
#ifdef MMDF
extern void do_mmdf_addresses P_((FILE *dest_file,
				  struct mailing_headers * headers));
#endif

/* editmsg.c */

extern int edit_the_message P_((char *filename,
				int  already_has_text,
				struct mailing_headers * headers,
				char *editor));


/* delete.c */

extern void delete_msg   P_((int real_del, int update_screen));
extern void undelete_msg P_((int update_screen));
extern void show_msg_status P_((int msg));
extern void show_msg_tag    P_((int msg));
extern void show_new_status P_((int msg));
extern int DeleteTagged     P_((void));

/* encode.c */

extern void getkey P_((int send));
extern void get_key_no_prompt P_((void));
extern void encode P_((char *line));
extern void makekey P_((char *rkey));
extern void setup P_((void));

/* forms.c */

extern int format_form P_((char *filename));
extern int check_form_file P_((char *filename));

/* quit.c */

extern void quit P_((int prompt));

/* save_opts.c */

extern void save_options P_((void));
extern void save_user_options P_((FILE *elminfo_fd, FILE *newelmrc));


/* screen.c */

extern void showscreen P_((void));
extern void update_title P_((void));
extern void show_menu P_((void));
extern void show_current P_((void));

/* showmsg_c.c */

extern void put_cmd_name P_((char *command, int will_mangle));
extern void put_border P_((void));
extern void build_bottom P_((void));

/* sort.c */

extern void sort_mailbox P_((int entries, int visible));

