/* $Id: listadm.c,v 1.1.1.1 1998/08/21 18:11:02 root Exp $ */

#include <unistd.h>
#include "list.h"
#include "tool.h"
#include "cgitool.h"
#include "cgipath.h"

void main_menu()
{
	html_head(VERSION);
	puts("<H1>BeroList list administration tool</H1><HR>");
	printf("<P><FORM METHOD=GET ACTION=%s>",LISTADM_CGI);
	puts("List: <INPUT TYPE=TEXT NAME=list>");
	puts("Password: <INPUT TYPE=PASSWORD NAME=pw>");
	#ifdef PASSWORD
		puts("<BR>(To create a new list, use the system password)");
	#else
		puts("<BR>(To create a new list, leave the password field blank.)");
	#endif
	puts("<P><SELECT NAME=menu>");
	puts("<OPTION VALUE=new>Create new list");
	puts("<OPTION VALUE=edit>Edit settings");
	puts("<OPTION VALUE=subscribe>Subscribe new user");
	puts("<OPTION VALUE=unsubscribe>Unsubscribe users");
	puts("<OPTION VALUE=addop>Add operator");
	puts("<OPTION VALUE=rmop>Remove operators");
	puts("<OPTION VALUE=delete>Delete list");
	puts("<OPTION VALUE=edit-arc>Edit list archive");
	puts("</SELECT>");
	puts("<P><INPUT TYPE=Submit VALUE=Proceed>");
	puts("</FORM>");
}

void edit_list(char *listname, char list_exists)
{
	char *configfile;
	char *cfg,*tmp;

	configfile=salloc(slen(LISTDIR)+1+strlen(listname)+7+1);
	sprintf(configfile,"%s/%s.config",LISTDIR,listname);
	if(list_exists==1) {
		cfg=readfile(configfile);
		if(cfg==NULL) {
			html_head("List editing error");
			puts("Can't open list config file for reading.");
			return;
		}
		if(listname==NULL) {
			html_head("List editing error");
			puts("List name not specified.");
			return;
		}
		html_head("Edit mailing list");
	} else {
		#ifdef PASSWORD
			if(scasecmp(PASSWORD,cgi_scan("pw"))!=0) {
				html_head("List creation error");
				puts("Wrong password.");
				return;
			}
		#endif
		if(exist(configfile)) {
			html_head("Error: Mailing list exists");
			puts("The mailing list already exists.");
			return;
		}
		cfg=salloc(1);
		html_head("Create new mailing list");
	}
		
	puts("<H1>BeroList list administration tool</H1><HR>");
	printf("<P><FORM METHOD=GET ACTION=%s>",LISTADM_CGI);
	if(list_exists==1)
		puts("<INPUT TYPE=HIDDEN NAME=menu VALUE=editlist>");
	else
		puts("<INPUT TYPE=HIDDEN NAME=menu VALUE=newlist>");

	#ifdef PASSWORD
		if(list_exists==0)
			printf("<INPUT TYPE=HIDDEN NAME=pw VALUE=\"%s\">",cgi_scan("pw"));
	#endif
	if(list_exists==1)
		printf("<INPUT TYPE=HIDDEN NAME=pw VALUE=\"%s\">",cgi_scan("pw"));

	if(listname==NULL)
		puts("<P><BR>List name: <INPUT TYPE=TEXT NAME=list>");
	else {
		printf("<INPUT TYPE=HIDDEN NAME=list VALUE=%s>",listname);	
		printf("<H1><CENTER>%s</CENTER></H1>",listname);
	}

	puts("<P><HR><CENTER><H2>General setup</H2></CENTER><HR>");

	tmp=extract(cfg,"newusers=",'\n');
	puts("<P><BR>Should new users be allowed to subscribe?");
	printf("<BR><INPUT TYPE=CHECKBOX NAME=newusers VALUE=yes");
	if(scasecmp(tmp,"no")!=0) printf(" CHECKED");
	printf(">Allow new users to subscribe");
	
	tmp=extract(cfg,"closed=",'\n');
	puts("<P><BR>Who should be allowed to post messages to the list?");
	puts("<BR><INPUT TYPE=RADIO NAME=closed VALUE=no>Everyone");
	printf("<BR><INPUT TYPE=RADIO NAME=closed VALUE=yes");
	if(scasecmp(tmp,"yes")==0 || tmp==NULL) printf(" CHECKED");
	puts(">Everyone who is subscribed");
	printf("<BR><INPUT TYPE=RADIO NAME=closed VALUE=operators");
	if(scasecmp(tmp,"operators")==0) printf(" CHECKED");
	puts(">Only list operators");

	tmp=extract(cfg,"contact=",'\n');
	puts("<P><BR>Address of list operator:");
	printf("<BR><INPUT TYPE=TEXT NAME=contact");
	if(tmp==NULL)
		puts(">");
	else
		printf(" VALUE=%s>",tmp);
	
	tmp=extract(cfg,"sender=",'\n');
	puts("<P><BR>Messages sent from the list should appear to be sent from");
	printf("<BR><INPUT TYPE=RADIO NAME=sender VALUE=list");
	if(scasecmp(tmp,"list")==0) printf(" CHECKED");
	puts(">the list");
	printf("<BR><INPUT TYPE=RADIO NAME=sender VALUE=original");
	if(scasecmp(tmp,"original")==0 || tmp==NULL) printf(" CHECKED");
	puts(">the original sender");
	printf("<BR><INPUT TYPE=RADIO NAME=sender VALUE=other");
	if(tmp!=NULL && scasecmp(tmp,"list")!=0 && scasecmp(tmp,"original")!=0)
		printf(" CHECKED");
	printf(">other: <INPUT TYPE=TEXT NAME=sender-adr");
	if(tmp!=NULL && scasecmp(tmp,"list")!=0 && scasecmp(tmp,"original")!=0)
		printf(" VALUE=%s>",tmp);
	else
		printf(">");

	tmp=extract(cfg,"replyto=",'\n');
	puts("<P><BR>Messages should have the following address in the Reply-To header:");
	puts("<BR><INPUT TYPE=RADIO NAME=replyto VALUE=sender>the original sender");
	printf("<BR><INPUT TYPE=RADIO NAME=replyto VALUE=list");
	if(scasecmp(tmp,"list")==0) printf(" CHECKED");
	puts(">the list address");
	printf("<BR><INPUT TYPE=RADIO NAME=replyto VALUE=other");
	if(tmp!=NULL && scasecmp(tmp,"list")!=0 && scasecmp(tmp,"sender")!=0) printf(" CHECKED");
	puts(">other: <INPUT TYPE=TEXT NAME=replyto-adr");
	if(tmp!=NULL && scasecmp(tmp,"list")!=0 && scasecmp(tmp,"sender")!=0) printf(" VALUE=%s",tmp);
	puts(">");
	printf("<BR><INPUT TYPE=RADIO NAME=replyto VALUE=none");
	if(tmp==NULL) printf(" CHECKED");
	puts(">None");
	
	tmp=extract(cfg,"errors=",'\n');
	puts("<P><BR>How should the list handle error messages?");
	puts("<BR><INPUT TYPE=RADIO NAME=errors VALUE=unsubscribe>Automatically unsubscribe faulty addresses");
	printf("<BR><INPUT TYPE=RADIO NAME=errors VALUE=forward");
	if(scasecmp(tmp,"forward")==0) printf(" CHECKED");
	puts(">Forward message to list operator");
	printf("<BR><INPUT TYPE=RADIO NAME=errors VALUE=both");
	if(scasecmp(tmp,"both")==0) printf(" CHECKED");
	puts(">Both");
	
	tmp=extract(cfg,"errors-to=",'\n');
	puts("<P><BR>E-Mail Address that will receive error messages");
	printf("<BR><INPUT TYPE=TEXT NAME=errors-to");
	if(tmp!=NULL) printf(" VALUE=%s",tmp);
	puts(">");
	
	#ifdef LOG
		tmp=extract(cfg,"log=",'\n');
		puts("<P><BR>If you wish to keep a log file for the list, enter the filename below.");
		printf("<BR><INPUT TYPE=TEXT NAME=log");
		if(tmp!=NULL) printf(" VALUE=%s",tmp);
		puts(">");
	#endif

	#if defined(ARCHIVE) && defined(HAVE_GDBM)
		tmp=extract(cfg,"archive=",'\n');
		puts("<P><BR>If you wish to create a message archive, enter the filename below.");
		printf("<BR><INPUT TYPE=TEXT NAME=archive");
		if(tmp!=NULL) printf(" VALUE=%s",tmp);
		puts(">");
	#endif

	#ifdef HAS_NNTP
		puts("<P><HR><CENTER><H2>News gateway</H2></CENTER><HR>");
		tmp=extract(cfg,"newsgroup",'\n');
		puts("<P><BR>If you wish to use the news gateway, enter the newsgroup that should receive copies of all messages below.");
		printf("<BR><INPUT TYPE=TEXT NAME=newsgroup");
		if(tmp!=NULL) printf(" VALUE=%s",tmp);
		puts(">");
		
		tmp=extract(cfg,"nntp-server",'\n');
		puts("<P><BR>NNTP (News) server:");
		printf("<BR><INPUT TYPE=TEXT NAME=nntp-server");
		if(tmp!=NULL) printf(" VALUE=%s",tmp);
		puts(">");

		tmp=extract(cfg,"distribution=",'\n');
		puts("<P><BR>News distribution:");
		puts("<BR><INPUT TYPE=RADIO NAME=distribution VALUE=local>local");
		printf("<BR><INPUT TYPE=RADIO NAME=distribution VALUE=world");
		if(scasecmp(tmp,"world")==0) printf(" CHECKED");
		puts(">world");
	#endif

	puts("<P><HR><CENTER><H2>WWW based list administration</H2></CENTER><HR>");
	puts("<P><BR>New password to be used for WWW based administration of this list:");
	puts("<BR><INPUT TYPE=PASSWORD NAME=www-password>");
	puts("<P><BR>Re-enter password for verification");
	puts("<BR><INPUT TYPE=PASSWORD NAME=www-password-rpt>");
	if(list_exists==0)
		puts("<P><BR><BR><INPUT TYPE=SUBMIT VALUE=\"Create list\"");
	else
		puts("<P><BR><BR><INPUT TYPE=SUBMIT VALUE=\"Edit settings\"");
	puts("</FORM>");
}

void create_list(char *listname, char update_aliases)
{
	char *configfile,*config,*oldpass=NULL;
	FILE *cfg,*aliases;
	if(listname==NULL) {
		html_head("List creation error");
		puts("List name not specified.");
		return;
	}
	#ifdef PASSWORD
		if(update_aliases==1 && scasecmp(cgi_scan("pw"),PASSWORD)!=0) {
			html_head("List creation error");
			puts("Wrong password.");
			return;
		}
	#endif
	if(scasecmp(cgi_scan("www-password"),cgi_scan("www-password-rpt"))!=0) {
		html_head("List creation error");
		puts("Password and repeated password don't match.<BR>Try again.");
		return;
	}
	if(cgi_scan("log")!=NULL) {
		config=cgi_scan("log");
		if((config[0]=='/') || strstr(config,"../")!=NULL) {
			html_head("List creation error");
			puts("Log path is absolute or contains ..<BR>For security reasons, you may not do this.");
			return;
		}
	}
	if(cgi_scan("archive")!=NULL) {
		config=cgi_scan("archive");
		if((config[0]=='/') || strstr(config,"../")!=NULL) {
			html_head("List creation error");
			puts("Archive path is absolute or contains ..<BR>For security reasons, you may not do this.");
			return;
		}
	}


	configfile=salloc(slen(LISTDIR)+1+strlen(listname)+7+1);
	sprintf(configfile,"%s/%s.config",LISTDIR,listname);
	
	if(exist(configfile) && update_aliases==0) {
		config=readfile(configfile);
		if(config==NULL) {
			html_head("List editing error");
			puts("Can't open old config file.");
			return;
		}
		oldpass=extract(config,"www-password=",'\n');
		if(unlink(configfile)!=0) {
			html_head("List editing error");
			puts("Can't delete old config file.");
			return;
		}
	}
	
	cfg=fopen(configfile,"w");
	if(cfg==NULL) {
		html_head("List creation error");
		printf("Can't open %s for writing.",configfile);
		printf("<BR>UID is %u; GID is %u",geteuid(),getegid());
		puts("<BR>Either make this CGI script setuid, or use group permissions.");
		return;
	}
	fprintf(cfg,"# List created using WWW gateway from %s (%s:%s)\n",getenv("REMOTE_HOST"),getenv("REMOTE_ADDR"),getenv("REMOTE_PORT"));
	if(scasecmp(cgi_scan("newusers"),"no")==0)
		fputs("newusers=no\n",cfg);
	else
		fputs("newusers=yes\n",cfg);
		
	if(scasecmp(cgi_scan("closed"),"yes")==0)
		fputs("closed=yes\n",cfg);
	else if(scasecmp(cgi_scan("closed"),"operators")==0)
		fputs("closed=operators\n",cfg);
	else
		fputs("closed=no\n",cfg);

	if(cgi_scan("contact")!=NULL)
		fprintf(cfg,"contact=%s\n",cgi_scan("contact"));
		
	if(scasecmp(cgi_scan("sender"),"original")==0)
		fputs("sender=original\n",cfg);
	else if(scasecmp(cgi_scan("sender"),"other")==0 && cgi_scan("sender-adr")!=NULL)
		fprintf(cfg,"sender=%s\n",cgi_scan("sender-adr"));
	else
		fputs("sender=list\n",cfg);
	
	if(scasecmp(cgi_scan("replyto"),"sender")==0)
		fputs("replyto=sender\n",cfg);
	else if(scasecmp(cgi_scan("replyto"),"list")==0)
		fputs("replyto=list\n",cfg);

	else if(scasecmp(cgi_scan("replyto"),"other")==0 && cgi_scan("replyto-adr")!=NULL)
		fprintf(cfg,"replyto=%s\n",cgi_scan("replyto-adr"));
	
	if(scasecmp(cgi_scan("errors"),"forward")==0)
		fputs("errors=forward\n",cfg);
	else if(scasecmp(cgi_scan("errors"),"unsubscribe")==0 || cgi_scan("errors-to")==NULL)
		fputs("errors=unsubscribe\n",cfg);
	else
		fputs("errors=both\n",cfg);
		
	if(cgi_scan("errors-to")!=NULL)
		fprintf(cfg,"errors-to=%s\n",cgi_scan("errors-to"));
		
	if(cgi_scan("log")!=NULL)
		fprintf(cfg,"log=%s\n",cgi_scan("log"));
		
	if(cgi_scan("newsgroup")!=NULL && cgi_scan("nntp-server")!=NULL) {
		fprintf(cfg,"newsgroup=%s\n",cgi_scan("newsgroup"));
		fprintf(cfg,"nntp-server=%s\n",cgi_scan("nntp-server"));
		if(scasecmp(cgi_scan("distribution"),"world")==0)
			fputs("distribution=world\n",cfg);
		else
			fputs("distribution=local\n",cfg);
	}
	
	if(cgi_scan("archive")!=NULL)
		fprintf(cfg,"archive=%s\n",cgi_scan("archive"));
	
	if(cgi_scan("www-password")!=NULL)
		fprintf(cfg,"www-password=%s\n",cgi_scan("www-password"));
	else if(oldpass!=NULL)
		fprintf(cfg,"www-password=%s\n",oldpass);
	
	fclose(cfg);
	
	if(update_aliases==1) {
		html_head("List creation succeeded.");
		printf("List %s created.",listname);
	} else {
		html_head("List editing succeeded.");
		printf("New settings are now in effect.");
	}
	
	if(update_aliases==1) {
		aliases=fopen("/etc/aliases","a");
		if(aliases==NULL) {
			puts("<P>This CGI script does not have access permissions to the /etc/aliases file,");
			puts("so you will have to edit that file manually (or tell the system administrator to do so).");
			puts("<BR>Don't forget to run newaliases after editing the file.");
		} else {
			fprintf(aliases,"%s:\"|%s/list %s\"\n",listname,BINDIR,listname);
			fclose(aliases);
			puts("<P>Entry to /etc/aliases made.");
			system("newaliases");
		}
	}
	
	printf("<P><BR><A HREF=%s?menu=main>Back to main menu</A>",LISTADM_CGI);
}

void subscribe_menu(char *list, char what)
{
	if(what==0)
		html_head("Subscribe new users");
	else
		html_head("Add operators");
	printf("<FORM METHOD=GET ACTION=%s>",LISTADM_CGI);
	printf("<INPUT TYPE=HIDDEN NAME=menu VALUE=");
	if(what==0)
		puts("add-user>");
	else
		puts("add-operator>");
	printf("<INPUT TYPE=HIDDEN NAME=list VALUE=%s>",list);
	printf("<INPUT TYPE=HIDDEN NAME=pw VALUE=%s>",cgi_scan("pw"));
	if(what==0)
		printf("<H1>Subscribe new user to list %s</H1><HR>",list);
	else
		printf("<H1>Add operator to list %s</H1><HR>",list);
	puts("<P>E-mail address: <INPUT TYPE=TEXT NAME=user>");
	printf("<INPUT TYPE=SUBMIT VALUE=");
	if(what==0)
		puts("Subscribe>");
	else
		puts("Add>");
	puts("</FORM>");
}

void add_user(char *list, char what)
{
	char *listfile, *members, *user, *w;
	FILE *f;
	
	w=salloc(9);
	if(what==0) {
		strcpy(w,"member");
		html_head("User subscription");
	} else {
		strcpy(w,"operator");
		html_head("Adding operator");
	}
	user=cgi_scan("user");
	if(user==NULL) {
		puts("Error: User not specified.");
		return;
	}
	listfile=salloc(slen(LISTDIR)+slen(list)+slen(w)+4);
	sprintf(listfile,"%s/%s.%ss",LISTDIR,list,w);
	members=readfile(listfile);
	if(list==NULL) {
		f=fopen(listfile,"w");
	} else {
		if(strcasestr(members,email(user))!=NULL) {
			if(what==0)
				puts("Error: User is already subscribed.");
			else
				puts("Error: User is already list operator.");
			return;
		}
		f=fopen(listfile,"a");
	}
	if(f==NULL) {
		printf("Error: can't open %s for writing.",listfile);
		return;
	}
	fprintf(f,"%s\n",user);
	fclose(f);
	if(what==0)
		puts("User subscribed successfully.");
	else
		puts("Operator added successfully.");
}

void unsubscribe_menu(char *list, char what)
{
	register int users=0;
	char *w, *listfile, *user;
	FILE *f;
	
	w=salloc(9);
	if(what==0) {
		html_head("Unsubscribe user(s)");
		puts("Select user(s) to unsubscribe:<P>");
		strcpy(w,"member");
	} else {
		html_head("Remove operator(s)");
		puts("Select operator(s) to remove:<P>");
		strcpy(w,"operator");
	}
	printf("<FORM METHOD=GET ACTION=%s>",LISTADM_CGI);
	printf("<INPUT TYPE=HIDDEN NAME=menu VALUE=");
	if(what==0)
		puts("rm-user>");
	else
		puts("rm-operator>");
	printf("<INPUT TYPE=HIDDEN NAME=list VALUE=%s>",list);
	printf("<INPUT TYPE=HIDDEN NAME=pw VALUE=%s>",cgi_scan("pw"));
	listfile=salloc(slen(LISTDIR)+slen(list)+slen(w)+4);
	sprintf(listfile,"%s/%s.%ss",LISTDIR,list,w);
	f=fopen(listfile,"r");
	if(f!=NULL) {
		while(!feof(f)) {
			user=readline(f);
			if(slen(user)>2 && user[0]!='#') {
				printf("<BR><INPUT TYPE=CHECKBOX NAME=user%u VALUE=y>%s",users++,user);
			}
		}
		fclose(f);
	}
	puts("<P><INPUT TYPE=SUBMIT VALUE=Remove>");
}

void del_user(char *list, char what)
{
	register int users=0;
	char *w, *listfile, *member[MAX_MEMBERS];
	char *user, *ustr;
	FILE *f;
	int i;
	
	w=salloc(9); ustr=salloc(10);
	if(what==0) {
		html_head("Unsubscribing user(s)");
		puts("Users successfully unsubscribed.");
		strcpy(w,"member");
	} else {
		html_head("Removing operator(s)");
		puts("Operators successfully removed.");
		strcpy(w,"operator");
	}
	listfile=salloc(slen(LISTDIR)+slen(list)+slen(w)+4);
	sprintf(listfile,"%s/%s.%ss",LISTDIR,list,w);
	f=fopen(listfile,"r");
	while(!feof(f)) {
		user=readline(f);
		if(slen(user)>2 && user[0]!='#') {
			member[users++]=user;
		}
	}
	fclose(f);
	f=fopen(listfile,"w");
	for(i=0;i<users;i++) {
		sprintf(ustr,"user%u",i);
		if(scasecmp(cgi_scan(ustr),"y")!=0)
			fprintf(f,"%s\n",member[i]);
	}
	fclose(f);
}

int delete_list(char *list)
{
	char *filename;
	
	html_head("Deleting list");
	filename=(char *) salloc(slen(LISTDIR)+strlen(list)+11);
	sprintf(filename,"%s/%s.config",LISTDIR,list);
	unlink(filename);
	sprintf(filename,"%s/%s.members",LISTDIR,list);
	unlink(filename);
	sprintf(filename,"%s/%s.operators",LISTDIR,list);
	unlink(filename);
	sprintf(filename,"%s/%s.footer",LISTDIR,list);
	unlink(filename);
	sprintf(filename,"%s/%s.welcome",LISTDIR,list);
	unlink(filename);
	puts("List files have been deleted. You will have to delete the entry in /etc/aliases manually.");
}

int main(int argc, char *argv[])
{
	char *menu,*list;
	char *configfile,*cfg,*pass;
	
	menu=cgi_scan("menu");
	list=cgi_scan("list");
	
	if(menu==NULL || scasecmp(menu,"main")==0)
		main_menu();
 	else if(scasecmp(menu,"new")==0)
		edit_list(list,0);
	else if(scasecmp(menu,"newlist")==0)
		create_list(list,1);
	else {
		configfile=salloc(slen(LISTDIR)+1+strlen(list)+7+1);
		sprintf(configfile,"%s/%s.config",LISTDIR,list);
		if(exist(configfile)==0) {
			html_head("List configuration error");
			printf("List %s does not exist.",list);
			return 0;
		}
		cfg=readfile(configfile);
		pass=extract(cfg,"www-password=",'\n');
		if(pass==NULL) {
			html_head("List configuration error");
			printf("List %s is not configured for WWW based administration.",list);
			printf("<BR>(www-password is not set.)");
			return 0;
		}
		if(scmp(pass,cgi_scan("pw"))!=0) {
			html_head("List configuration error");
			printf("Wrong password for list %s.",list);
			if(scasecmp(pass,cgi_scan("pw"))==0)
				printf("<BR>Passwords are case sensitive.");
			return 0;
		}
		if(scasecmp(menu,"edit")==0)
			edit_list(list,1);
		else if(scasecmp(menu,"editlist")==0)
			create_list(list,0);
		else if(scasecmp(menu,"subscribe")==0)
			subscribe_menu(list,0); 
		else if(scasecmp(menu,"add-user")==0)
			add_user(list,0);
		else if(scasecmp(menu,"addop")==0)
			subscribe_menu(list,1); 
		else if(scasecmp(menu,"add-operator")==0)
			add_user(list,1);
		else if(scasecmp(menu,"unsubscribe")==0)
			unsubscribe_menu(list,0);
		else if(scasecmp(menu,"rmop")==0)
			unsubscribe_menu(list,1);
		else if(scasecmp(menu,"rm-user")==0)
			del_user(list,0);
		else if(scasecmp(menu,"rm-operator")==0)
			del_user(list,1);
		else if(scasecmp(menu,"delete")==0)
			delete_list(list);
		else if(scasecmp(menu,"edit-arc")==0) {
			html_head(VERSION);
			printf("<META HTTP-EQUIV=REFRESH CONTENT=\"1; URL=%s?list=%s&pw=%s&function=edit\">",MESSAGES_CGI,list,pass);
			puts("Apparently, your browser does not understand the &lt;REFRESH&gt; redirection");
			puts("HTML tag.");
			printf("<BR><A HREF=%s?list=%s&pw=%s&function=edit>Click here.</A>",MESSAGES_CGI,list,pass);
		} else {
			html_head(VERSION);
			printf("Error: unknown command %s.",menu);
		}
	}
}
