/* $Id: edit.c,v 1.1.1.1 1998/08/21 18:11:02 root Exp $ */

#include "list.h"
#include "tool.h"
#include "cgitool.h"
#include "cgipath.h"
#include <gdbm.h>

void errhead()
{
	html_head("Server configuration error");
	puts("<H1>Server configuration error</H1><HR>");
}

int main(int argc, char *argv[])
{
	char *listname, *configfile, *config, *archivefile;
	char *d_key, *s;
	GDBM_FILE db;
	datum key,content;
	unsigned int num,msg,i,function;
	
	listname=cgi_scan("list");
	if(listname==NULL) {
		errhead();
		puts("The BeroList message list script is not configured correctly.<BR>");
		puts("You have to specify the parameter list=listname.");
		exit(1);
	}
	if(scasecmp(cgi_scan("function"),"edit")==0)
		function=1;
	else if(scasecmp(cgi_scan("function"),"delete")==0)
		function=2;

	s=cgi_scan("msg");
	if(s==NULL)
		i=0;
	else
		i=atoi(s);
	
	configfile=salloc(slen(LISTDIR)+slen(listname)+9);
	sprintf(configfile,"%s/%s.config",LISTDIR,listname);
	config=readfile(configfile);
	if(config==NULL) {
		errhead();
		printf("The specified list, %s, does not exist.",listname);
		exit(1);
	}

	if(extract(config,"www-password=",'\n')==NULL) {
		errhead();
		puts("This list is not configured for WWW based administration.");
	} else if(scmp(extract(config,"www-password=",'\n'),cgi_scan("pw"))!=0) {
		errhead();
		puts("Wrong password.");
	}

	archivefile=extract(config,"archive=",'\n');
	if(archivefile==NULL) {
		archivefile=salloc(slen(LISTDIR)+slen(listname)+10);
		sprintf(archivefile,"%s/%s.archive",LISTDIR,listname);
	}
	if(scasecmp(archivefile,"none")==0) {
		errhead();
		printf("The specified list, %s, does not archive messages.",listname);
		exit(1);
	} else if(archivefile[0]!='/') {
		archivefile=(char *) realloc(archivefile,slen(LISTDIR)+slen(archivefile)+2);
		sprintf(archivefile,"%s/%s\0",LISTDIR,archivefile);
	}

	db=gdbm_open(archivefile,0,GDBM_WRITER,00664,0);
	if(db==NULL) {
		errhead();
		printf("Couldn't open archive file for list %s.",listname);
		exit(1);
	}

	html_head("BeroList message editor");
	
	s=cgi_scan("msg");
	msg=atoi(s);
	d_key=salloc(12);
	
	switch(function) {
	case 1: /* Edit */
		sprintf(d_key,"%u",msg);
		key.dptr=d_key;
		key.dsize=slen(d_key);	
		s=cgi_scan("text");
		content.dptr=s;
		content.dsize=slen(s);
		gdbm_store(db,key,content,GDBM_REPLACE);
		sprintf(d_key,"f%u",msg);
		key.dptr=d_key;
		key.dsize=slen(d_key);	
		s=cgi_scan("from");
		content.dptr=s;
		content.dsize=slen(s);
		gdbm_store(db,key,content,GDBM_REPLACE);
		sprintf(d_key,"s%u",msg);
		key.dptr=d_key;
		key.dsize=slen(d_key);	
		s=cgi_scan("subject");
		content.dptr=s;
		content.dsize=slen(s);
		gdbm_store(db,key,content,GDBM_REPLACE);
		break;
	case 2: /* Delete */
		sprintf(d_key,"num");
		key.dptr=d_key;
		key.dsize=3;
		content=gdbm_fetch(db,key);
		num=atoi(content.dptr);
		for(i=msg;i<num;i++) {
			sprintf(d_key,"%u\0",i+1);
			key.dsize=slen(d_key);
			content=gdbm_fetch(db,key);
			sprintf(d_key,"%u\0",i);
			key.dsize=slen(d_key);
			gdbm_store(db,key,content,GDBM_REPLACE);
			sprintf(d_key,"s%u\0",i+1);
			key.dsize=slen(d_key);
			content=gdbm_fetch(db,key);
			sprintf(d_key,"s%u\0",i);
			key.dsize=slen(d_key);
			gdbm_store(db,key,content,GDBM_REPLACE);
			sprintf(d_key,"f%u\0",i+1);
			key.dsize=slen(d_key);
			content=gdbm_fetch(db,key);
			sprintf(d_key,"f%u\0",i);
			key.dsize=slen(d_key);
			gdbm_store(db,key,content,GDBM_REPLACE);
			sprintf(d_key,"d%u\0",i+1);
			key.dsize=slen(d_key);
			content=gdbm_fetch(db,key);
			sprintf(d_key,"d%u\0",i);
			key.dsize=slen(d_key);
			gdbm_store(db,key,content,GDBM_REPLACE);
		}
		sprintf(d_key,"%u\0",num); /* Delete last message */
		key.dsize=slen(d_key);
		gdbm_delete(db,key);
		sprintf(d_key,"s%u\0",num);
		key.dsize=slen(d_key);
		gdbm_delete(db,key);
		sprintf(d_key,"f%u\0",num);
		gdbm_delete(db,key);
		sprintf(d_key,"d%u\0",num);
		gdbm_delete(db,key);
		sprintf(d_key,"num\0");     /* Change number of messages */
		key.dsize=slen(d_key);
		s=salloc(12);
		sprintf(s,"%u",num-1);
		content.dptr=s;
		content.dsize=slen(s);
		gdbm_store(db,key,content,GDBM_REPLACE);
		gdbm_reorganize(db);
		break;
	}
	
	gdbm_close(db);
	
	puts("Message successfully modified.");
	return 0;
}
