/* $Id: cgitool.c,v 1.1.1.1 1998/08/21 18:11:02 root Exp $ */

#include "tool.h"
#include "cgitool.h"

char *cgi_scan(char *setting) 
{
	char *par, *loc, *cont;
	char *buf;
	char *ascii;
	register int i;
	
	par=getenv("QUERY_STRING");
	if(par==NULL) return NULL;
	buf=salloc(slen(par)+1);
	strcpy(buf,par);
	
	loc=strtok(buf,"&");
	while (loc) {
		cont=strstr(loc,setting);
		if(cont==loc) {
			loc=strchr(cont,'=')+1;
			loc=strdup(loc);
			for(i=0;i<slen(loc);i++) {
				if(loc[i]=='+') loc[i]=' '; /* CGI: spaces are replaced by + */
				if(loc[i]=='%') {		/* special chars... %2F = / */
					if(loc[i+1]!='%') {
						ascii=salloc(3);
						ascii[0]=loc[i+1];
						ascii[1]=loc[i+2];
						loc[i]=(char) strtol(ascii,NULL,16);
						strcpy(loc+i+1,loc+i+3);
					} else
						i++;
				}
			}
			free(buf);
			if(slen(loc)==0) /* Treat empty fields as nonexistant */
				return NULL;
			return loc;
		} else
			loc=strtok(NULL,"&");
	}
	free(buf);
	return NULL;
}

unsigned int cgi_count()
{
	char *par, *loc;
	char *buf;
	register int count=0;
	
	par=getenv("QUERY_STRING");
	if(par==NULL) return 0;
	buf=salloc(slen(par)+1);
	strcpy(buf,par);
	
	loc=strtok(buf,"&");
	while (loc) {
		count++;
		loc=strtok(NULL,"&");
	}
	free(buf);
	return count;
}

char *to_cgi(char *t)
{
	char *cgi;
	register int i;
	int loc=0;
	
	cgi=salloc(3*slen(t));
	for(i=0;i<slen(t);i++) {
		if((t[i]>='a' && t[i]<='z') || (t[i]>='A' && t[i]<='Z'))
			cgi[loc++]=t[i];
		else if(t[i]==' ')
			cgi[loc++]='+';
		else if(t[i]!='\r') {
			sprintf(cgi+loc,"%%%2x",t[i]);
			loc+=3;
		}
	}
	cgi=(char *) realloc(cgi,slen(cgi)+1);
	return cgi;
}

void html_head(char *title)
{
	puts("Content-Type: text/html\n\n");
	puts("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
	printf("<HTML><HEAD><TITLE>%s: %s</TITLE>",VERSION,title);
	printf("<META NAME=Generator CONTENT=%s>",VERSION);
	puts("<BODY>");
}
