/*
 * Copyright (c) 1997, 1998 Akira Yoshiyama <yosshy@debian.or.jp>
 * Copyright (c) 1998 Fumitoshi UKAI <ukai@debian.or.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public Licenses as
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * mbsrtowcs_locale ()
 * for conversion from multibyte character to UCS-4
 * programed
 *   by A. Yoshiyama (yosshy@jedi.seg.kobe-u.ac.jp)
 *   on Dec.17,1996
 */

#include <errno.h>
#include <wchar.h>
#include <wcsmbs_locale.h>

#if DEBUG
#include <stdio.h>
#include <stdlib.h>
#endif

extern size_t
dll_mbsnrtowcs_locale (wchar_t *, const char **, size_t, size_t, mbstate_t *);

size_t
dll_mbsrtowcs_locale (dst, src, len, ps)
     wchar_t *dst;
     const char **src;
     size_t len;
     mbstate_t *ps;
{
  int result;
  static mbstate_t internal = {0, (wint_t)0};

#if DEBUG
  fprintf(stderr,"%s:dll_mbsrtowcs_locale(dst, src, len, ps)\n",
	  getenv(MONENV));
  fprintf(stderr,"dst=%p, src=%p, len=%d, ps=%p)\n", dst, src, len, ps);
#endif

  if (ps == NULL)
    ps = &internal;

  result = dll_mbsnrtowcs_locale (dst, src, SIZE_T_MAX, len, ps);
#if DEBUG
  fprintf(stderr,"dll_mbsrtowcs_locale:result = %d\n", result);
#endif

  return result;
}
