/*
 * GWT - General Windowing Toolkit
 *
 * Copyright (C) 1998 MenTaLguY - mentalg@geocities.com
 *                    Rodolphe Ortalo - ortalo@laas.fr
 *                    Tristan Wibberley - twibberley@llamacom.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: region.c,v $
 * Revision 1.6  1998/09/02 02:21:47  tristan
 * Loadsa great stuff done. Visible/invalid regions,
 *  copy on move - fixed tt_region.c too!
 *
 * Revision 1.5  1998/08/23 18:57:14  ortalo
 * Minor editing (mainly comments).
 *
 * Revision 1.4  1998/08/16 18:40:57  ortalo
 * A new version, STILL IN VERY ALPHA STATE... (Be patient.)
 * (However, this version is a little better... :-)
 *
 * Revision 1.3  1998/08/15 16:15:31  marcus
 * Fixed to compile with -pedantic
 *
 * Revision 1.2  1998/08/11 22:10:10  ortalo
 * Incorporated the changes made by Tristan Wibberley. The code is
 * still in alpha development state.
 *
 * Revision 1.1  1998/07/09 18:38:39  ortalo
 * Initial integration of libgwt in the GGI repository.
 * This is experimental code, for your eyes only !
 * (Don't execute... ;-)
 *
 */

#include <malloc.h>
#include "internal.h"

/*
 * HERE: We assume that region_t and gwt_region are the SAME TYPE.
 * (I simply just reuse Thomas Tanner implementation for the moment.)
 */

/* Preallocated space for the rect list of a region */
#define _GWT_REGION_LIMIT 5

/*******************************************************************
 *                  GWT PRIVATE EXPORTED FUNCTIONS                 *
 *******************************************************************/

int gwt_region_create(gwt_region_t *region)
{
  return (((*region)=(gwt_region *)malloc(sizeof(gwt_region))) != NULL ? 1 : 0);
}
int gwt_region_init(gwt_region_t region, int left, int top,
					 int right, int bottom)
{
  rect_t rect;
  /* Set region == rect */
  
  rectAssign(&rect, left, top, right-1, bottom-1);
  if (regionInit(region, 0)) {
    regionIntersectRect(region, &rect);		/* No more */
    regionAddRect(region, &rect);		/* No less */
    return 1;
  }
  return 0;
}
int gwt_region_copy(gwt_region_t dest, gwt_region_t src)
{
  return regionCopy(dest, src);
}
int gwt_region_union(gwt_region_t resr1, gwt_region_t r2)
{
  regionAdd(resr1, r2);
  return 1;
}
int gwt_region_intersection(gwt_region_t resr1, gwt_region_t r2)
{
  return regionIntersect(resr1, r2);	/* different return, 1 if intersect, 0 if not - useful? -- Tristan */
}
int gwt_region_difference(gwt_region_t resr1, gwt_region_t r2)
{
  return regionSubtract(resr1, r2);	/* TODO: check return vals */
}
int gwt_region_move(gwt_region_t region, int dx, int dy)
{
  regionMove(region, dx, dy);
  return 1;
}
int gwt_region_bounds(gwt_region_t region, ggi_coord *tl, ggi_coord *br)
{
  rect_t bbox;
  regionBoundingBox(region, &bbox);
  (*tl).x=bbox.left;
  (*tl).y=bbox.top;
  (*br).x=bbox.right;
  (*br).y=bbox.bottom;
  return 1;
}
int gwt_region_contains_point(gwt_region_t region, int x, int y)
{
  return regionContainsPoint(region, x, y);
}
int gwt_region_rect(gwt_region_t region, int rectno,
			ggi_coord *tl, ggi_coord *br)
{
  if ((rectno < 0) || (rectno >= region->size)) return 0;
  (*tl).x=region->rect[rectno].left;
  (*tl).y=region->rect[rectno].top;
  (*br).x=region->rect[rectno].right;
  (*br).y=region->rect[rectno].bottom;
  return 1;
}
int gwt_region_destroy(gwt_region_t region)
{
  regionFree(region);
  free(region);
  return 1;
}

/*******************************************************************
 *                  GWT PUBLIC EXPORTED FUNCTIONS                  *
 *******************************************************************/

/*
 * Creation functions
 * Note, in these cases '0' means success (for external API consistency)
 */
int gwtRegionCreate(gwt_region_t *region)
{
  /* We init because all regions ought to have at least one rect */
  return !(gwt_region_create(region) && gwt_region_init((*region), 0,0,0,0));
}
int gwtRegionCopy(gwt_region_t dest, gwt_region_t src)
{
  return !gwt_region_copy(dest, src);
}
/*
 * Test function
 */
int gwtRegionIsEmpty(gwt_region_t region)
{
  return regionEmpty(region);
}
/*
 * Manipulation functions
 */
int gwtRegionUnion(gwt_region_t u, gwt_region_t r1, gwt_region_t r2)
{
  return !(gwt_region_copy(u, r1) && gwt_region_union(u, r2));
}
int gwtRegionIntersection(gwt_region_t isect, gwt_region_t r1, gwt_region_t r2)
{
  gwt_region_copy(isect, r1);
  gwt_region_intersection(isect, r2);	/* Hmm, is that difference of return vals useful */
  return 0;
}
int gwtRegionDifference(gwt_region_t diff, gwt_region_t r1, gwt_region_t r2)
{
  gwt_region_copy(diff, r1);
  gwt_region_difference(diff, r2);	/* Here too */
  return 0;
}
/*
 * Destructor
 */
void gwtRegionDestroy(gwt_region_t r)
{
  gwt_region_destroy(r);
}
